/*
 * Decompiled with CFR 0.152.
 */
package ee.ut.soras.ajavtV2.mudel.sonamallid;

import ee.ut.soras.ajavtV2.mudel.AjavtSona;
import ee.ut.soras.ajavtV2.mudel.ajavaljend.SemantikaDefinitsioon;
import ee.ut.soras.ajavtV2.mudel.sonamallid.MallileVastavus;
import ee.ut.soras.ajavtV2.mudel.sonamallid.SonaMall;
import ee.ut.soras.ajavtV2.mudel.sonamallid.SonaMalliSemOsa;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class RegExpSonaMall
extends SonaMalliSemOsa
implements SonaMall {
    private Pattern regexp;

    public RegExpSonaMall(String string) {
        try {
            this.regexp = Pattern.compile(string);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            this.regexp = null;
        }
    }

    @Override
    public MallileVastavus vastabMallile(AjavtSona ajavtSona) {
        boolean bl = false;
        if (this.regexp != null) {
            Matcher matcher = this.regexp.matcher(ajavtSona.getAlgSonaYmbritsevateMarkideta());
            bl = matcher.matches();
        }
        return bl ? MallileVastavus.VASTAB_LOPLIKULT : MallileVastavus.EI_VASTA;
    }

    public String toString() {
        return "/" + this.regexp.pattern() + "/";
    }

    @Override
    public SonaMall.TYYP getTyyp() {
        return SonaMall.TYYP.REGEXP;
    }

    @Override
    public List<SemantikaDefinitsioon> tagastaMalliSemantilineOsa(AjavtSona ajavtSona) {
        List<String> list;
        int[] nArray = super.getSemValueReferences();
        List<SemantikaDefinitsioon> list2 = super.tagastaMalliSemantilineOsa(ajavtSona);
        if (nArray != null && list2 != null && this.regexp != null && nArray.length == list2.size() && !(list = this.parsiSobitunudAlamgrupid(ajavtSona, nArray)).isEmpty()) {
            for (int i = 0; i < nArray.length; ++i) {
                SemantikaDefinitsioon semantikaDefinitsioon = list2.get(i);
                int n = nArray[i];
                if (n <= -1 || semantikaDefinitsioon == null || list.get(i).length() <= 0) continue;
                semantikaDefinitsioon.setSemValue(list.get(i));
            }
        }
        return list2;
    }

    public List<String> parsiSobitunudAlamgrupid(AjavtSona ajavtSona, int[] nArray) {
        Matcher matcher;
        LinkedList<String> linkedList = new LinkedList<String>();
        if (nArray != null && (matcher = this.regexp.matcher(ajavtSona.getAlgSonaYmbritsevateMarkideta())).matches()) {
            for (int i = 0; i < nArray.length; ++i) {
                int n = nArray[i];
                if (n > -1) {
                    if (n > matcher.groupCount()) continue;
                    linkedList.add(matcher.group(n));
                    continue;
                }
                linkedList.add("");
            }
        }
        return linkedList;
    }
}

