from setuptools import setup

setup(
    name='addonpy',
    version='1.0.8',
    author='Ninad Mhatre',
    author_email='ninad.mhatre@gmail.com',
    packages=['addonpy',
              'addonpy.tests'],
    package_data={'addonpy.tests': ['*.bat', '*.txt', '*.py'],
                  'addonpy.tests.data': ['*.info', '*.py'],
                  'addonpy.tests.data.sub': ['*.info', '*.py'],
                  'addonpy.examples': ['*.txt', '*.info', '*.py'],
                  'addonpy.docs': ['*.html'],
                  'addonpy': ['.version'],
                  'addonpy.scripts': ['*.conf', '*.py']},
    include_package_data=True,
    url='https://github.com/ninadmhatre/addonpy/wiki',
    license='MIT',
    description='A simple addon/plug-in module',
    scripts=['addonpy/scripts/addon_generator.py', 'addonpy/scripts/template.conf'],
    classifiers=[
        'Development Status :: 4 - Beta',
        'Intended Audience :: Developers',
        'Natural Language :: English',
        'License :: OSI Approved :: MIT License',
        'Operating System :: OS Independent',
        'Programming Language :: Python',
        'Programming Language :: Python :: 2.7',
        'Programming Language :: Python :: 3.2',
        'Programming Language :: Python :: 3.3',
        'Programming Language :: Python :: 3.4',
        'Topic :: Software Development :: Libraries :: Python Modules',
    ],
)
