
"""
    This code was generated by Codezu.     

    Changes to this file may cause incorrect behavior and will be lost if
    the code is regenerated.
"""


from mozurestsdk.mozuclient import default as default_client
from mozurestsdk.mozuurl import MozuUrl;
from mozurestsdk.urllocation import UrlLocation
from mozurestsdk.apicontext import ApiContext;

class CustomerCheckoutSettings(object):
	def __init__(self, apiContext: ApiContext = None, mozuClient = None):
		self.client = mozuClient or default_client();
		if (apiContext is not None):
			self.client.withApiContext(apiContext);
		else:
			self.client.withApiContext(ApiContext());
	
	def getCustomerCheckoutSettings(self,responseFields = None):
		""" Retrieves all checkout settings defined for the site: Payment settings, such as the payment gateway ID and credentials, supported credit cards, and more; Customer Checkout settings, such as whether login is required, and any custom attributes; and Order Processing settings, such as when payment is authorized and captured, and any custom attributes.
		
		Args:
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| CustomerCheckoutSettings 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/settings/checkout/customercheckoutsettings?responseFields={responseFields}", "GET", UrlLocation.TenantPod, False);
		url.formatUrl("responseFields", responseFields);
		self.client.withResourceUrl(url).execute();
		return self.client.result();

	
		
	def updateCustomerCheckoutSettings(self,customerCheckoutSettings, responseFields = None):
		""" Modifies existing site checkout settings. Modify Payment, Customer Checkout, and Order Processing settings in one PUT.
		
		Args:
			| customerCheckoutSettings(customerCheckoutSettings) - The properties of the customer checkout settings such as whether shoppers must be logged in.
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| CustomerCheckoutSettings 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/settings/checkout/customercheckoutsettings?responseFields={responseFields}", "PUT", UrlLocation.TenantPod, False);
		url.formatUrl("responseFields", responseFields);
		self.client.withResourceUrl(url).withBody(customerCheckoutSettings).execute();
		return self.client.result();

	
	
	