
"""
    This code was generated by Codezu.     

    Changes to this file may cause incorrect behavior and will be lost if
    the code is regenerated.
"""


from mozurestsdk.mozuclient import default as default_client
from mozurestsdk.mozuurl import MozuUrl;
from mozurestsdk.urllocation import UrlLocation
from mozurestsdk.apicontext import ApiContext;

class OrderNote(object):
	def __init__(self, apiContext: ApiContext = None, mozuClient = None):
		self.client = mozuClient or default_client();
		if (apiContext is not None):
			self.client.withApiContext(apiContext);
		else:
			self.client.withApiContext(ApiContext());
	
	def getOrderNotes(self,orderId):
		""" Retrieves a list of all notes for an order.
		
		Args:
			| orderId (string) - Unique identifier of the order.
		
		Returns:
			| array of OrderNote 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/orders/{orderId}/notes", "GET", UrlLocation.TenantPod, False);
		url.formatUrl("orderId", orderId);
		self.client.withResourceUrl(url).execute();
		return self.client.result();

	
		
	def getOrderNote(self,orderId, noteId, responseFields = None):
		""" Retrieves the details of a specific order note.
		
		Args:
			| orderId (string) - Unique identifier of the order.
			| noteId (string) - Unique identifier of a particular note to retrieve.
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| OrderNote 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/orders/{orderId}/notes/{noteId}?responseFields={responseFields}", "GET", UrlLocation.TenantPod, False);
		url.formatUrl("noteId", noteId);
		url.formatUrl("orderId", orderId);
		url.formatUrl("responseFields", responseFields);
		self.client.withResourceUrl(url).execute();
		return self.client.result();

	
		
	def createOrderNote(self,orderNote, orderId, responseFields = None):
		""" Creates a new merchant note for the specified order.
		
		Args:
			| orderNote(orderNote) - Properties of an order note for a merchant, which is internal only for administrative purposes and not available to the shopper.
			| orderId (string) - Unique identifier of the order.
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| OrderNote 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/orders/{orderId}/notes?responseFields={responseFields}", "POST", UrlLocation.TenantPod, False);
		url.formatUrl("orderId", orderId);
		url.formatUrl("responseFields", responseFields);
		self.client.withResourceUrl(url).withBody(orderNote).execute();
		return self.client.result();

	
		
	def updateOrderNote(self,orderNote, orderId, noteId, responseFields = None):
		""" Updates a specific note for an order.
		
		Args:
			| orderNote(orderNote) - Properties of an order note for a merchant, which is internal only for administrative purposes and not available to the shopper.
			| orderId (string) - Unique identifier of the order.
			| noteId (string) - Unique identifier of a particular note to retrieve.
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| OrderNote 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/orders/{orderId}/notes/{noteId}?responseFields={responseFields}", "PUT", UrlLocation.TenantPod, False);
		url.formatUrl("noteId", noteId);
		url.formatUrl("orderId", orderId);
		url.formatUrl("responseFields", responseFields);
		self.client.withResourceUrl(url).withBody(orderNote).execute();
		return self.client.result();

	
		
	def deleteOrderNote(self,orderId, noteId):
		""" Deletes the specified order note.
		
		Args:
			| orderId (string) - Unique identifier of the order.
			| noteId (string) - Unique identifier of a particular note to retrieve.
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/orders/{orderId}/notes/{noteId}", "DELETE", UrlLocation.TenantPod, False);
		url.formatUrl("noteId", noteId);
		url.formatUrl("orderId", orderId);
		self.client.withResourceUrl(url).execute();

	
	
	