
"""
    This code was generated by Codezu.     

    Changes to this file may cause incorrect behavior and will be lost if
    the code is regenerated.
"""


from mozurestsdk.mozuclient import default as default_client
from mozurestsdk.mozuurl import MozuUrl;
from mozurestsdk.urllocation import UrlLocation
from mozurestsdk.apicontext import ApiContext;

class Credit(object):
	def __init__(self, apiContext: ApiContext = None, mozuClient = None):
		self.client = mozuClient or default_client();
		if (apiContext is not None):
			self.client.withApiContext(apiContext);
		else:
			self.client.withApiContext(ApiContext());
	
	def getCredits(self,startIndex = None, pageSize = None, sortBy = None, filter = None, responseFields = None):
		""" Retrieves a list of store credits applied to customer accounts, according any filter and sort criteria specified in the request.
		
		Args:
			| startIndex (int) - When creating paged results from a query, this value indicates the zero-based offset in the complete result set where the returned entities begin. For example, with a PageSize of 25, to get the 51st through the 75th items, use startIndex=3.
			| pageSize (int) - The number of results to display on each page when creating paged results from a query. The maximum value is 200.
			| sortBy (string) - The property by which to sort results and whether the results appear in ascending (a-z) order, represented by ASC or in descending (z-a) order, represented by DESC. The sortBy parameter follows an available property. For example: "sortBy=productCode+asc"
			| filter (string) - A set of expressions that consist of a field, operator, and value and represent search parameter syntax when filtering results of a query. Valid operators include equals (eq), does not equal (ne), greater than (gt), less than (lt), greater than or equal to (ge), less than or equal to (le), starts with (sw), or contains (cont). For example - "filter=IsDisplayed+eq+true"
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| CreditCollection 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/customer/credits/?startIndex={startIndex}&pageSize={pageSize}&sortBy={sortBy}&filter={filter}&responseFields={responseFields}", "GET", UrlLocation.TenantPod, False);
		url.formatUrl("filter", filter);
		url.formatUrl("pageSize", pageSize);
		url.formatUrl("responseFields", responseFields);
		url.formatUrl("sortBy", sortBy);
		url.formatUrl("startIndex", startIndex);
		self.client.withResourceUrl(url).execute();
		return self.client.result();

	
		
	def getCredit(self,code, responseFields = None):
		""" Retrieves the details of a store credit applied to a customer account.
		
		Args:
			| code (string) - User-defined code that uniqely identifies the channel group.
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| Credit 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/customer/credits/{code}?responseFields={responseFields}", "GET", UrlLocation.TenantPod, False);
		url.formatUrl("code", code);
		url.formatUrl("responseFields", responseFields);
		self.client.withResourceUrl(url).execute();
		return self.client.result();

	
		
	def addCredit(self,credit, responseFields = None):
		""" Creates a new store credit for the customer account specified in the request.
		
		Args:
			| credit(credit) - Properties of the store credit of gift card applied to a customer account. At this time, gift card functionality is reserved for future use.
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| Credit 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/customer/credits/?responseFields={responseFields}", "POST", UrlLocation.TenantPod, False);
		url.formatUrl("responseFields", responseFields);
		self.client.withResourceUrl(url).withBody(credit).execute();
		return self.client.result();

	
		
	def associateCreditToShopper(self,code, responseFields = None):
		""" Associates an unclaimed customer credit with the shopper user authenticated in the request header.
		
		Args:
			| code (string) - User-defined code that uniqely identifies the channel group.
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| Credit 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/customer/credits/{code}/associate-to-shopper?responseFields={responseFields}", "PUT", UrlLocation.TenantPod, False);
		url.formatUrl("code", code);
		url.formatUrl("responseFields", responseFields);
		self.client.withResourceUrl(url).execute();
		return self.client.result();

	
		
	def resendCreditCreatedEmail(self,code):
		""" customer-credits Put ResendCreditCreatedEmail description DOCUMENT_HERE 
		
		Args:
			| code (string) - User-defined code that uniqely identifies the channel group.
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/customer/credits/{code}/Resend-Email", "PUT", UrlLocation.TenantPod, False);
		url.formatUrl("code", code);
		self.client.withResourceUrl(url).execute();

	
		
	def updateCredit(self,credit, code, responseFields = None):
		""" Updates one or more properties of a defined store credit applied to a customer account.
		
		Args:
			| credit(credit) - Properties of the store credit of gift card applied to a customer account. At this time, gift card functionality is reserved for future use.
			| code (string) - User-defined code that uniqely identifies the channel group.
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| Credit 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/customer/credits/{code}?responseFields={responseFields}", "PUT", UrlLocation.TenantPod, False);
		url.formatUrl("code", code);
		url.formatUrl("responseFields", responseFields);
		self.client.withResourceUrl(url).withBody(credit).execute();
		return self.client.result();

	
		
	def deleteCredit(self,code):
		""" Deletes a store credit previously applied to a customer account.
		
		Args:
			| code (string) - User-defined code that uniqely identifies the channel group.
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/customer/credits/{code}", "DELETE", UrlLocation.TenantPod, False);
		url.formatUrl("code", code);
		self.client.withResourceUrl(url).execute();

	
	
	