
"""
    This code was generated by Codezu.     

    Changes to this file may cause incorrect behavior and will be lost if
    the code is regenerated.
"""


from mozurestsdk.mozuclient import default as default_client
from mozurestsdk.mozuurl import MozuUrl;
from mozurestsdk.urllocation import UrlLocation
from mozurestsdk.apicontext import ApiContext;

class LocationInventory(object):
	def __init__(self, apiContext: ApiContext = None, dataViewMode="Live", mozuClient = None):
		if (apiContext is not None and apiContext.dataViewMode is None):
			apiContext.dataViewMode = dataViewMode;
		else:
			apiContext = ApiContext(dataViewMode = dataViewMode);
		self.client = mozuClient or default_client();
		self.client.withApiContext(apiContext);
	
	def getLocationInventories(self,productCode, startIndex = None, pageSize = None, sortBy = None, filter = None, responseFields = None):
		""" Retrieves all locations for which a product has inventory defined and displays the inventory definition properties of each location.
		
		Args:
			| productCode (string) - Merchant-created code that uniquely identifies the product such as a SKU or item number. Once created, the product code is read-only.
			| startIndex (int) - When creating paged results from a query, this value indicates the zero-based offset in the complete result set where the returned entities begin. For example, with a PageSize of 25, to get the 51st through the 75th items, use startIndex=3.
			| pageSize (int) - The number of results to display on each page when creating paged results from a query. The maximum value is 200.
			| sortBy (string) - The property by which to sort results and whether the results appear in ascending (a-z) order, represented by ASC or in descending (z-a) order, represented by DESC. The sortBy parameter follows an available property. For example: "sortBy=productCode+asc"
			| filter (string) - A set of expressions that consist of a field, operator, and value and represent search parameter syntax when filtering results of a query. Valid operators include equals (eq), does not equal (ne), greater than (gt), less than (lt), greater than or equal to (ge), less than or equal to (le), starts with (sw), or contains (cont). For example - "filter=IsDisplayed+eq+true"
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| LocationInventoryCollection 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/catalog/admin/products/{ProductCode}/LocationInventory/?startIndex={startIndex}&pageSize={pageSize}&sortBy={sortBy}&filter={filter}&responseFields={responseFields}", "GET", UrlLocation.TenantPod, False);
		url.formatUrl("filter", filter);
		url.formatUrl("pageSize", pageSize);
		url.formatUrl("productCode", productCode);
		url.formatUrl("responseFields", responseFields);
		url.formatUrl("sortBy", sortBy);
		url.formatUrl("startIndex", startIndex);
		self.client.withResourceUrl(url).execute();
		return self.client.result();

	
		
	def getLocationInventory(self,productCode, locationCode, responseFields = None):
		""" Retrieves the details of the inventory of the product in the location specified in the request.
		
		Args:
			| productCode (string) - Merchant-created code that uniquely identifies the product such as a SKU or item number. Once created, the product code is read-only.
			| locationCode (string) - The unique, user-defined code that identifies a location. 
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| LocationInventory 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/catalog/admin/products/{ProductCode}/LocationInventory/{LocationCode}?responseFields={responseFields}", "GET", UrlLocation.TenantPod, False);
		url.formatUrl("locationCode", locationCode);
		url.formatUrl("productCode", productCode);
		url.formatUrl("responseFields", responseFields);
		self.client.withResourceUrl(url).execute();
		return self.client.result();

	
		
	def addLocationInventory(self,locationInventoryList, productCode, performUpserts = False):
		""" Creates a new location inventory definition for the product code specified in the request.
		
		Args:
			| locationInventoryList(array|locationInventoryList) - Properties of an inventory definition that defines the level of inventory for a specific product at a given location.
			| productCode (string) - Merchant-created code that uniquely identifies the product such as a SKU or item number. Once created, the product code is read-only.
			| performUpserts (bool) - Query string parameter lets the service perform an update for a new or existing record. When run, the update occurs without throwing a conflict exception that the record exists. If true, the updates completes regardless of the record currently existing. By default, if no value is specified, the service assumes this value is false.
		
		Returns:
			| array of LocationInventory 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/catalog/admin/products/{ProductCode}/LocationInventory?performUpserts={performUpserts}", "POST", UrlLocation.TenantPod, False);
		url.formatUrl("performUpserts", performUpserts);
		url.formatUrl("productCode", productCode);
		self.client.withResourceUrl(url).withBody(locationInventoryList).execute();
		return self.client.result();

	
		
	def updateLocationInventory(self,locationInventoryAdjustments, productCode):
		""" Updates the current level of stock at each location associated with the product code specified in the request.
		
		Args:
			| locationInventoryAdjustments(array|locationInventoryAdjustments) - Properties of an adjustment to the active product inventory of a specific location.
			| productCode (string) - The unique, user-defined product code of a product, used throughout Mozu to reference and associate to a product.
		
		Returns:
			| array of LocationInventory 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/catalog/admin/products/{ProductCode}/LocationInventory", "PUT", UrlLocation.TenantPod, False);
		url.formatUrl("productCode", productCode);
		self.client.withResourceUrl(url).withBody(locationInventoryAdjustments).execute();
		return self.client.result();

	
		
	def deleteLocationInventory(self,productCode, locationCode):
		""" Deletes the location inventory definition for the product code specified in the request.
		
		Args:
			| productCode (string) - The unique, user-defined product code of a product, used throughout Mozu to reference and associate to a product.
			| locationCode (string) - The unique, user-defined code that identifies a location. 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/catalog/admin/products/{ProductCode}/LocationInventory/{LocationCode}", "DELETE", UrlLocation.TenantPod, False);
		url.formatUrl("locationCode", locationCode);
		url.formatUrl("productCode", productCode);
		self.client.withResourceUrl(url).execute();

	
	
	