
"""
    This code was generated by Codezu.     

    Changes to this file may cause incorrect behavior and will be lost if
    the code is regenerated.
"""


from mozurestsdk.mozuclient import default as default_client
from mozurestsdk.mozuurl import MozuUrl;
from mozurestsdk.urllocation import UrlLocation
from mozurestsdk.apicontext import ApiContext;

class Coupon(object):
	def __init__(self, apiContext: ApiContext = None, mozuClient = None):
		self.client = mozuClient or default_client();
		if (apiContext is not None):
			self.client.withApiContext(apiContext);
		else:
			self.client.withApiContext(ApiContext());
	
	def getCoupon(self,couponSetCode, couponCode, includeCounts = False, responseFields = None):
		""" couponsets-coupons Get GetCoupon description DOCUMENT_HERE 
		
		Args:
			| couponSetCode (string) - 
			| couponCode (string) - Code associated with the coupon to remove from the cart.
			| includeCounts (bool) - 
			| responseFields (string) - A list or array of fields returned for a call. These fields may be customized and may be used for various types of data calls in Mozu. For example, responseFields are returned for retrieving or updating attributes, carts, and messages in Mozu.
		
		Returns:
			| Coupon 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/catalog/admin/couponsets/{couponSetCode}/couponcodes/{couponCode}?includeCounts={includeCounts}&responseFields={responseFields}", "GET", UrlLocation.TenantPod, False);
		url.formatUrl("couponCode", couponCode);
		url.formatUrl("couponSetCode", couponSetCode);
		url.formatUrl("includeCounts", includeCounts);
		url.formatUrl("responseFields", responseFields);
		self.client.withResourceUrl(url).execute();
		return self.client.result();

	
		
	def getCoupons(self,couponSetCode, startIndex = None, pageSize = None, sortBy = None, filter = None, includeCounts = False, responseFields = None):
		""" couponsets-coupons Get GetCoupons description DOCUMENT_HERE 
		
		Args:
			| couponSetCode (string) - 
			| startIndex (int) - When creating paged results from a query, this value indicates the zero-based offset in the complete result set where the returned entities begin. For example, with a  pageSize  of 25, to get the 51st through the 75th items, use  startIndex=3 .
			| pageSize (int) - The number of results to display on each page when creating paged results from a query. The amount is divided and displayed on the  pageCount  amount of pages. The default is 20 and maximum value is 200 per page.
			| sortBy (string) - The element to sort the results by and the channel in which the results appear. Either ascending (a-z) or descending (z-a) channel. Optional.
			| filter (string) - A set of filter expressions representing the search parameters for a query: eq=equals, ne=not equals, gt=greater than, lt = less than or equals, gt = greater than or equals, lt = less than or equals, sw = starts with, or cont = contains. Optional.
			| includeCounts (bool) - 
			| responseFields (string) - A list or array of fields returned for a call. These fields may be customized and may be used for various types of data calls in Mozu. For example, responseFields are returned for retrieving or updating attributes, carts, and messages in Mozu.
		
		Returns:
			| CouponCollection 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/catalog/admin/couponsets/{couponSetCode}/couponcodes?startIndex={startIndex}&pageSize={pageSize}&sortBy={sortBy}&filter={filter}&includeCounts={includeCounts}&responseFields={responseFields}", "GET", UrlLocation.TenantPod, False);
		url.formatUrl("couponSetCode", couponSetCode);
		url.formatUrl("filter", filter);
		url.formatUrl("includeCounts", includeCounts);
		url.formatUrl("pageSize", pageSize);
		url.formatUrl("responseFields", responseFields);
		url.formatUrl("sortBy", sortBy);
		url.formatUrl("startIndex", startIndex);
		self.client.withResourceUrl(url).execute();
		return self.client.result();

	
		
	def addCoupons(self,coupons, couponSetCode):
		""" couponsets-coupons Post AddCoupons description DOCUMENT_HERE 
		
		Args:
			| coupons(array|coupons) - Mozu.ProductAdmin.Contracts.Coupon ApiType DOCUMENT_HERE 
			| couponSetCode (string) - 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/catalog/admin/couponsets/{couponSetCode}/couponcodes", "POST", UrlLocation.TenantPod, False);
		url.formatUrl("couponSetCode", couponSetCode);
		self.client.withResourceUrl(url).withBody(coupons).execute();

	
		
	def deleteCoupons(self,couponCodes, couponSetCode):
		""" couponsets-coupons Post DeleteCoupons description DOCUMENT_HERE 
		
		Args:
			| couponCodes(array|couponCodes) - 
			| couponSetCode (string) - 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/catalog/admin/couponsets/{couponSetCode}/couponcodes/remove", "POST", UrlLocation.TenantPod, False);
		url.formatUrl("couponSetCode", couponSetCode);
		self.client.withResourceUrl(url).withBody(couponCodes).execute();

	
		
	def deleteCoupon(self,couponSetCode, couponCode):
		""" couponsets-coupons Delete DeleteCoupon description DOCUMENT_HERE 
		
		Args:
			| couponSetCode (string) - 
			| couponCode (string) - Code associated with the coupon to remove from the cart.
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/catalog/admin/couponsets/{couponSetCode}/couponcodes/{couponCode}", "DELETE", UrlLocation.TenantPod, False);
		url.formatUrl("couponCode", couponCode);
		url.formatUrl("couponSetCode", couponSetCode);
		self.client.withResourceUrl(url).execute();

	
	
	