
"""
    This code was generated by Codezu.     

    Changes to this file may cause incorrect behavior and will be lost if
    the code is regenerated.
"""


from mozurestsdk.mozuclient import default as default_client
from mozurestsdk.mozuurl import MozuUrl;
from mozurestsdk.urllocation import UrlLocation
from mozurestsdk.apicontext import ApiContext;

class AttributeLocalizedContent(object):
	def __init__(self, apiContext: ApiContext = None, mozuClient = None):
		self.client = mozuClient or default_client();
		if (apiContext is not None):
			self.client.withApiContext(apiContext);
		else:
			self.client.withApiContext(ApiContext());
	
	def getAttributeLocalizedContents(self,attributeFQN):
		""" Retrieves a collection of localized content for attributes based on a  localeCode .
		
		Args:
			| attributeFQN (string) - Fully qualified name for an attribute.
		
		Returns:
			| array of AttributeLocalizedContent 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/catalog/admin/attributedefinition/attributes/{attributeFQN}/LocalizedContent", "GET", UrlLocation.TenantPod, False);
		url.formatUrl("attributeFQN", attributeFQN);
		self.client.withResourceUrl(url).execute();
		return self.client.result();

	
		
	def getAttributeLocalizedContent(self,attributeFQN, localeCode, responseFields = None):
		""" Retrieves the localized content for an attribute  based on a  localeCode . 
		
		Args:
			| attributeFQN (string) - Fully qualified name for an attribute.
			| localeCode (string) - Language used for the entity. Currently, only "en-US" is supported.
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| AttributeLocalizedContent 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/catalog/admin/attributedefinition/attributes/{attributeFQN}/LocalizedContent/{localeCode}?responseFields={responseFields}", "GET", UrlLocation.TenantPod, False);
		url.formatUrl("attributeFQN", attributeFQN);
		url.formatUrl("localeCode", localeCode);
		url.formatUrl("responseFields", responseFields);
		self.client.withResourceUrl(url).execute();
		return self.client.result();

	
		
	def addLocalizedContent(self,localizedContent, attributeFQN, responseFields = None):
		""" Adds new localized content for an attribute  based on a  localeCode . 
		
		Args:
			| localizedContent(localizedContent) - The localized name and description of the attribute, displayed in the locale defined for the master catalog.
			| attributeFQN (string) - Fully qualified name for an attribute.
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| AttributeLocalizedContent 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/catalog/admin/attributedefinition/attributes/{attributeFQN}/LocalizedContent?responseFields={responseFields}", "POST", UrlLocation.TenantPod, False);
		url.formatUrl("attributeFQN", attributeFQN);
		url.formatUrl("responseFields", responseFields);
		self.client.withResourceUrl(url).withBody(localizedContent).execute();
		return self.client.result();

	
		
	def updateLocalizedContents(self,localizedContent, attributeFQN):
		""" Updates the localized content for a collection of existing attributes  based on a  localeCode . 
		
		Args:
			| localizedContent(array|localizedContent) - The localized name and description of the attribute, displayed in the locale defined for the master catalog.
			| attributeFQN (string) - Fully qualified name for an attribute.
		
		Returns:
			| array of AttributeLocalizedContent 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/catalog/admin/attributedefinition/attributes/{attributeFQN}/LocalizedContent", "PUT", UrlLocation.TenantPod, False);
		url.formatUrl("attributeFQN", attributeFQN);
		self.client.withResourceUrl(url).withBody(localizedContent).execute();
		return self.client.result();

	
		
	def updateLocalizedContent(self,localizedContent, attributeFQN, localeCode, responseFields = None):
		""" Updates the localized content for an existing attribute  based on a  localeCode . 
		
		Args:
			| localizedContent(localizedContent) - The localized name and description of the attribute, displayed in the locale defined for the master catalog.
			| attributeFQN (string) - Fully qualified name for an attribute.
			| localeCode (string) - Language used for the entity. Currently, only "en-US" is supported.
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| AttributeLocalizedContent 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/catalog/admin/attributedefinition/attributes/{attributeFQN}/LocalizedContent/{localeCode}?responseFields={responseFields}", "PUT", UrlLocation.TenantPod, False);
		url.formatUrl("attributeFQN", attributeFQN);
		url.formatUrl("localeCode", localeCode);
		url.formatUrl("responseFields", responseFields);
		self.client.withResourceUrl(url).withBody(localizedContent).execute();
		return self.client.result();

	
		
	def deleteLocalizedContent(self,attributeFQN, localeCode):
		""" Removes all localized content. Localized content is translated text information and data based on a  localeCode . 
		
		Args:
			| attributeFQN (string) - Fully qualified name for an attribute.
			| localeCode (string) - Language used for the entity. Currently, only "en-US" is supported.
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/catalog/admin/attributedefinition/attributes/{attributeFQN}/LocalizedContent/{localeCode}", "DELETE", UrlLocation.TenantPod, False);
		url.formatUrl("attributeFQN", attributeFQN);
		url.formatUrl("localeCode", localeCode);
		self.client.withResourceUrl(url).execute();

	
	
	