# -*- coding: utf-8 -*-
# Generated by Django 1.10.4 on 2016-12-19 22:26
from __future__ import unicode_literals

import ads.models
from django.conf import settings
import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Ad',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=255, verbose_name='Title')),
                ('image', models.ImageField(max_length=255, upload_to=b'', verbose_name='Image')),
                ('url', models.URLField(verbose_name='Advertised URL')),
                ('publication_date', models.DateTimeField(default=django.utils.timezone.now, verbose_name='Start showing')),
                ('publication_date_end', models.DateTimeField(default=ads.models.now_plus_1_day, verbose_name='Stop showing')),
                ('zone', models.CharField(max_length=100, verbose_name='Zone')),
                ('weight', models.IntegerField(default=1, help_text='Weight of the ad relative to other ads in the same zone.<br />Ad with higher weight will be displayed more frequently.', validators=[django.core.validators.MinValueValidator(1)], verbose_name='Weight')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('modified_at', models.DateTimeField(auto_now=True)),
            ],
            options={
                'verbose_name': 'Ad',
                'verbose_name_plural': 'Ads',
            },
        ),
        migrations.CreateModel(
            name='Advertiser',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('company_name', models.CharField(max_length=255, verbose_name='Company Name')),
                ('website', models.URLField(verbose_name='Company Site')),
                ('created_by', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL, verbose_name='Created By')),
            ],
            options={
                'ordering': ('company_name',),
                'verbose_name': 'Advertiser',
                'verbose_name_plural': 'Advertisers',
            },
        ),
        migrations.CreateModel(
            name='Category',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=255, verbose_name='Title')),
                ('description', models.TextField(blank=True, verbose_name='Description')),
                ('created_by', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL, verbose_name='Created By')),
            ],
            options={
                'ordering': ('title',),
                'verbose_name': 'Category',
                'verbose_name_plural': 'Categories',
            },
        ),
        migrations.CreateModel(
            name='Click',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('click_date', models.DateTimeField(auto_now_add=True, verbose_name='When')),
                ('source_ip', models.GenericIPAddressField(blank=True, null=True, verbose_name='Source IP Address')),
                ('session_id', models.CharField(blank=True, max_length=40, null=True, verbose_name='Source Session ID')),
                ('ad', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='clicks', to='ads.Ad', verbose_name='Ad')),
            ],
            options={
                'verbose_name': 'Ad Click',
                'verbose_name_plural': 'Ad Clicks',
            },
        ),
        migrations.CreateModel(
            name='Impression',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('impression_date', models.DateTimeField(auto_now_add=True, verbose_name='When')),
                ('source_ip', models.GenericIPAddressField(blank=True, null=True, verbose_name='Source IP Address')),
                ('session_id', models.CharField(blank=True, max_length=40, null=True, verbose_name='Source Session ID')),
                ('ad', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='impressions', to='ads.Ad', verbose_name='Ad')),
            ],
            options={
                'verbose_name': 'Ad Impression',
                'verbose_name_plural': 'Ad Impressions',
            },
        ),
        migrations.AddField(
            model_name='ad',
            name='advertiser',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='ads.Advertiser', verbose_name='Ad Provider'),
        ),
        migrations.AddField(
            model_name='ad',
            name='category',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='ads.Category', verbose_name='Category'),
        ),
        migrations.AddField(
            model_name='ad',
            name='created_by',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL, verbose_name='Created By'),
        ),
        migrations.AlterIndexTogether(
            name='impression',
            index_together=set([('ad', 'session_id')]),
        ),
        migrations.AlterIndexTogether(
            name='click',
            index_together=set([('ad', 'session_id')]),
        ),
    ]
