from .SMBase import SMBase
from .Types import Types

""" A class to generate html from test results.
"""

class Format(SMBase):
"""Input:
    scans: a list of lists generated by Scan
        element format: [host, command, result]
    stype: scan type (str) - the name of the scan template
"""

    def init(self, scans, stype="minimal"):
        # change scans into [host, [command, result], [command, result]] format
        hosts = list(set(map(lambda x: x[0], scans)))
        # probably exists something more efficient than double lc for this
        cmds = [[b[1:3] for b in scans if b[0]==x] for x in hosts]
        self.scans = [[hosts[x], cmd] for x, cmd in enumerate(cmds)]
        self.template = Types.get_template(stype)
        if not self.template:
            raise RuntimeError("Was not able to format scan template " + sytpe)

    def out(self):
        html=""
        # put header
        html = html + self.template[0]
        # for each host:
        for host in self.scans:
            html = html + (self.template[1].replace("{NAME}",host[0]))
            # now do each test for this host
            for test in host[1]:
                html = html + (self.template[2]
                               .replace("{description}",test[0])
                               .replace("{result}", test[1]))
        # now the footer
        html = html + self.template[3]
        return html
