##############################################################################
# Part of the Agnos RPC Framework
#    http://agnos.sourceforge.net
#
# Copyright 2011, International Business Machines Corp.
#                 Author: Tomer Filiba (tomerf@il.ibm.com)
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
##############################################################################
"""
libagnos - python implementation

This library is usually used by code generated by the Agnos compiler;
End-user code may use it to import various transports, exceptions classes,
and constants.
"""
from .transports import Transport, TransportFactory
from .transports import SocketTransport, SocketTransportFactory, ProcTransport
from .httptransport import HttpClientTransport

from .protocol import BaseRecord, BaseProxy, BaseClient, ClientUtils, BaseProcessor, Namespace
from .protocol import ProtocolError, PackedException, GenericException
from .packers import PackingError
from .protocol import WrongAgnosVersion, WrongServiceName, IncompatibleServiceVersion
from .protocol import INFO_META, INFO_SERVICE, INFO_FUNCTIONS, INFO_REFLECTION

from .utils import HeteroMap, Enum

