# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ShutdownNotificationContent(Model):
    """The contents of a shutdown notification. Webhooks can use this type to
    deserialize the request body when they get notified of an imminent
    shutdown.

    :param skip_url: The URL to skip auto-shutdown.
    :type skip_url: str
    :param delay_url60: The URL to delay shutdown by 60 minutes.
    :type delay_url60: str
    :param delay_url120: The URL to delay shutdown by 2 hours.
    :type delay_url120: str
    :param vm_name: The virtual machine to be shut down.
    :type vm_name: str
    :param guid: The GUID for the virtual machine to be shut down.
    :type guid: str
    :param owner: The owner of the virtual machine.
    :type owner: str
    :param vm_url: The URL of the virtual machine.
    :type vm_url: str
    :param minutes_until_shutdown: Minutes remaining until shutdown
    :type minutes_until_shutdown: str
    :param event_type: The event for which a notification will be sent.
    :type event_type: str
    :param text: The text for the notification.
    :type text: str
    :param subscription_id: The subscription ID for the schedule.
    :type subscription_id: str
    :param resource_group_name: The resource group name for the schedule.
    :type resource_group_name: str
    :param lab_name: The lab for the schedule.
    :type lab_name: str
    """

    _attribute_map = {
        'skip_url': {'key': 'skipUrl', 'type': 'str'},
        'delay_url60': {'key': 'delayUrl60', 'type': 'str'},
        'delay_url120': {'key': 'delayUrl120', 'type': 'str'},
        'vm_name': {'key': 'vmName', 'type': 'str'},
        'guid': {'key': 'guid', 'type': 'str'},
        'owner': {'key': 'owner', 'type': 'str'},
        'vm_url': {'key': 'vmUrl', 'type': 'str'},
        'minutes_until_shutdown': {'key': 'minutesUntilShutdown', 'type': 'str'},
        'event_type': {'key': 'eventType', 'type': 'str'},
        'text': {'key': 'text', 'type': 'str'},
        'subscription_id': {'key': 'subscriptionId', 'type': 'str'},
        'resource_group_name': {'key': 'resourceGroupName', 'type': 'str'},
        'lab_name': {'key': 'labName', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ShutdownNotificationContent, self).__init__(**kwargs)
        self.skip_url = kwargs.get('skip_url', None)
        self.delay_url60 = kwargs.get('delay_url60', None)
        self.delay_url120 = kwargs.get('delay_url120', None)
        self.vm_name = kwargs.get('vm_name', None)
        self.guid = kwargs.get('guid', None)
        self.owner = kwargs.get('owner', None)
        self.vm_url = kwargs.get('vm_url', None)
        self.minutes_until_shutdown = kwargs.get('minutes_until_shutdown', None)
        self.event_type = kwargs.get('event_type', None)
        self.text = kwargs.get('text', None)
        self.subscription_id = kwargs.get('subscription_id', None)
        self.resource_group_name = kwargs.get('resource_group_name', None)
        self.lab_name = kwargs.get('lab_name', None)
