# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .resource_py3 import Resource


class CustomImage(Resource):
    """A custom image.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The identifier of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param location: The location of the resource.
    :type location: str
    :param tags: The tags of the resource.
    :type tags: dict[str, str]
    :param vm: The virtual machine from which the image is to be created.
    :type vm: ~azure.mgmt.devtestlabs.models.CustomImagePropertiesFromVm
    :param vhd: The VHD from which the image is to be created.
    :type vhd: ~azure.mgmt.devtestlabs.models.CustomImagePropertiesCustom
    :param description: The description of the custom image.
    :type description: str
    :param author: The author of the custom image.
    :type author: str
    :ivar creation_date: The creation date of the custom image.
    :vartype creation_date: datetime
    :param managed_image_id: The Managed Image Id backing the custom image.
    :type managed_image_id: str
    :param managed_snapshot_id: The Managed Snapshot Id backing the custom
     image.
    :type managed_snapshot_id: str
    :param data_disk_storage_info: Storage information about the data disks
     present in the custom image
    :type data_disk_storage_info:
     list[~azure.mgmt.devtestlabs.models.DataDiskStorageTypeInfo]
    :param custom_image_plan: Storage information about the plan related to
     this custom image
    :type custom_image_plan:
     ~azure.mgmt.devtestlabs.models.CustomImagePropertiesFromPlan
    :param is_plan_authorized: Whether or not the custom images underlying
     offer/plan has been enabled for programmatic deployment
    :type is_plan_authorized: bool
    :ivar provisioning_state: The provisioning status of the resource.
    :vartype provisioning_state: str
    :ivar unique_identifier: The unique immutable identifier of a resource
     (Guid).
    :vartype unique_identifier: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'creation_date': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'unique_identifier': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'vm': {'key': 'properties.vm', 'type': 'CustomImagePropertiesFromVm'},
        'vhd': {'key': 'properties.vhd', 'type': 'CustomImagePropertiesCustom'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'author': {'key': 'properties.author', 'type': 'str'},
        'creation_date': {'key': 'properties.creationDate', 'type': 'iso-8601'},
        'managed_image_id': {'key': 'properties.managedImageId', 'type': 'str'},
        'managed_snapshot_id': {'key': 'properties.managedSnapshotId', 'type': 'str'},
        'data_disk_storage_info': {'key': 'properties.dataDiskStorageInfo', 'type': '[DataDiskStorageTypeInfo]'},
        'custom_image_plan': {'key': 'properties.customImagePlan', 'type': 'CustomImagePropertiesFromPlan'},
        'is_plan_authorized': {'key': 'properties.isPlanAuthorized', 'type': 'bool'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'unique_identifier': {'key': 'properties.uniqueIdentifier', 'type': 'str'},
    }

    def __init__(self, *, location: str=None, tags=None, vm=None, vhd=None, description: str=None, author: str=None, managed_image_id: str=None, managed_snapshot_id: str=None, data_disk_storage_info=None, custom_image_plan=None, is_plan_authorized: bool=None, **kwargs) -> None:
        super(CustomImage, self).__init__(location=location, tags=tags, **kwargs)
        self.vm = vm
        self.vhd = vhd
        self.description = description
        self.author = author
        self.creation_date = None
        self.managed_image_id = managed_image_id
        self.managed_snapshot_id = managed_snapshot_id
        self.data_disk_storage_info = data_disk_storage_info
        self.custom_image_plan = custom_image_plan
        self.is_plan_authorized = is_plan_authorized
        self.provisioning_state = None
        self.unique_identifier = None
