/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.data.util;

import org.brunel.data.Data;
import org.brunel.data.util.DateFormat;
import org.brunel.translator.JSTranslation;

public class ItemsList
implements Comparable<ItemsList> {
    private final Object[] items;
    private int displayCount = 12;

    public ItemsList(Object[] items) {
        this.items = items;
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof ItemsList && this.compareTo((ItemsList)obj) == 0;
    }

    public int hashCode() {
        int result = 1;
        for (Object element : this.items) {
            result = 31 * result + (element == null ? 0 : element.hashCode());
        }
        return result;
    }

    @Override
    public int compareTo(ItemsList o) {
        int n = Math.min(this.size(), o.size());
        for (int i = 0; i < n; ++i) {
            int d = Data.compare(this.get(i), o.get(i));
            if (d == 0) continue;
            return d;
        }
        return this.size() - o.size();
    }

    public Object get(int i) {
        return this.items[i];
    }

    public int size() {
        return this.items.length;
    }

    public void setDisplayCount(int displayCount) {
        this.displayCount = displayCount;
    }

    @JSTranslation(ignore=true)
    public String toString() {
        return this.toString(null);
    }

    public String toString(DateFormat dateFormat) {
        String s = "";
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                s = s + ", ";
            }
            if (i == this.displayCount - 1 && n > this.displayCount) {
                return s + "\u2026";
            }
            Object v = this.get(i);
            if (dateFormat != null) {
                String t = dateFormat.format(Data.asDate(v));
                int p = t.indexOf(44);
                if (p > 0) {
                    s = s + t.substring(0, p);
                    s = s + t.substring(p + 1);
                    continue;
                }
                s = s + t;
                continue;
            }
            Double d = Data.asNumeric(v);
            s = d != null ? s + Data.formatNumeric(d, false) : s + v.toString();
        }
        return s;
    }
}

