/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.data.stats;

import org.brunel.data.Field;
import org.brunel.data.util.DateFormat;
import org.brunel.data.util.DateUnit;

public class DateStats {
    public static void populate(Field f) {
        double days = f.max() - f.min();
        if (days == 0.0) {
            days = f.max();
        }
        DateUnit unit = DateStats.getUnit(days);
        f.set("dateUnit", (Object)unit);
        Double granularity = f.numProperty("granularity");
        double factor = Math.min(1.0, Math.sqrt(f.valid()) / 7.0);
        f.set("dateFormat", (Object)DateStats.getFormat(unit, granularity * factor));
    }

    public static DateUnit getUnit(double days) {
        for (DateUnit d : DateUnit.values()) {
            if (days > 3.5 * d.approxDaysPerUnit) {
                return d;
            }
            if (d != DateUnit.day || !(days >= 2.5 * d.approxDaysPerUnit)) continue;
            return d;
        }
        return DateUnit.second;
    }

    private static DateFormat getFormat(DateUnit unit, double granularity) {
        if (granularity > 360.0) {
            return DateFormat.Year;
        }
        if (granularity > 13.0) {
            return DateFormat.YearMonth;
        }
        if (granularity > 0.9) {
            return DateFormat.YearMonthDay;
        }
        if (unit.ordinal() < DateUnit.hour.ordinal()) {
            return DateFormat.DayHour;
        }
        if (granularity > 6.25E-4) {
            return DateFormat.HourMin;
        }
        return DateFormat.HourMinSec;
    }

    public static boolean creates(String key) {
        return "dateUnit".equals(key) || "dateFormat".equals(key);
    }
}

