/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.data.modify;

import java.util.ArrayList;
import org.brunel.data.Data;
import org.brunel.data.Dataset;
import org.brunel.data.Field;
import org.brunel.data.modify.DataOperation;

public class Filter
extends DataOperation {
    public static Dataset transform(Dataset base, String command) {
        String[] commands = Filter.strings(command, ';');
        int N = commands.length;
        if (N == 0) {
            return base;
        }
        Field[] field = new Field[N];
        int[] type = new int[N];
        Object[][] params = new Object[N][];
        for (int i = 0; i < N; ++i) {
            int p;
            String c = commands[i].trim();
            int q = c.indexOf(" ", (p = c.indexOf(" ")) + 1);
            if (q < 0) {
                q = c.length();
            }
            field[i] = base.field(c.substring(0, p).trim());
            int t = Filter.getType(c.substring(p, q).trim());
            Object[] par = Filter.getParams(c.substring(q).trim(), field[i].preferCategorical());
            if (t == 4 || t == -4) {
                par = Filter.getRankedObjects(field[i], Data.asNumeric(par[0]), Data.asNumeric(par[1]));
                t = t < 0 ? -3 : 3;
            }
            type[i] = t;
            params[i] = par;
        }
        int[] keep = Filter.makeRowsToKeep(field, type, params);
        return keep == null ? base : base.retainRows(keep);
    }

    private static Object[] getRankedObjects(Field field, double p1, double p2) {
        ArrayList<Object> data = new ArrayList<Object>();
        int n = field.rowCount();
        for (int i = 0; i < n; ++i) {
            Object o = field.value(i);
            if (o == null) continue;
            data.add(o);
        }
        Object[] d = data.toArray(new Object[data.size()]);
        Data.sort(d);
        int N = d.length;
        int a = Math.min(Math.max(1, (int)p1), N);
        int b = Math.min(Math.max(1, (int)p2), N);
        Object high = d[N - a];
        Object low = d[N - b];
        return new Object[]{low, high};
    }

    private static int getType(String s) {
        if (s.startsWith("!")) {
            return -Filter.getType(s.substring(1).trim());
        }
        if (s.equals("valid")) {
            return 1;
        }
        if (s.equals("is")) {
            return 2;
        }
        if (s.equals("in")) {
            return 3;
        }
        if (s.equals("ranked")) {
            return 4;
        }
        throw new IllegalArgumentException("Cannot use filter command " + s);
    }

    private static Object[] getParams(String s, boolean categorical) {
        String[] parts = s.split(",");
        Object[] result = new Object[parts.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = categorical ? parts[i].trim() : Data.asNumeric(parts[i].trim());
        }
        return result;
    }

    private static int[] makeRowsToKeep(Field[] field, int[] type, Object[][] params) {
        ArrayList<Integer> rows = new ArrayList<Integer>();
        int n = field[0].rowCount();
        for (int row = 0; row < n; ++row) {
            boolean bad = false;
            for (int i = 0; i < field.length; ++i) {
                Object v = field[i].value(row);
                if (v == null) {
                    bad = true;
                    break;
                }
                int t = type[i];
                Object[] pars = params[i];
                if (t == 2 || t == -2) {
                    bad = !Filter.matchAny(v, pars);
                } else if (t == 3 || t == -3) {
                    boolean bl = bad = Data.compare(v, pars[0]) < 0 || Data.compare(v, pars[1]) > 0;
                }
                if (t < 0) {
                    boolean bl = bad = !bad;
                }
                if (bad) break;
            }
            if (bad) continue;
            rows.add(row);
        }
        if (rows.size() == n) {
            return null;
        }
        int[] keep = new int[rows.size()];
        for (int i = 0; i < keep.length; ++i) {
            keep[i] = (Integer)rows.get(i);
        }
        return keep;
    }

    private static boolean matchAny(Object v, Object[] params) {
        for (Object p : params) {
            if (Data.compare(v, p) != 0) continue;
            return true;
        }
        return false;
    }
}

