/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.data.modify;

import java.util.ArrayList;
import org.brunel.data.Data;
import org.brunel.data.Dataset;
import org.brunel.data.Field;
import org.brunel.data.Fields;
import org.brunel.data.modify.DataOperation;
import org.brunel.data.util.ItemsList;

public class Each
extends DataOperation {
    public static Dataset transform(Dataset base, String command) {
        for (String s : Each.strings(command, ';')) {
            Field f = base.field(s);
            if (!f.isProperty("list")) continue;
            base = Each.splitListsInField(base, f);
        }
        return base;
    }

    private static Dataset splitListsInField(Dataset base, Field target) {
        ArrayList<Integer> rows = new ArrayList<Integer>();
        ArrayList<Object> fieldValues = new ArrayList<Object>();
        for (int i = 0; i < target.rowCount(); ++i) {
            ItemsList list = (ItemsList)target.value(i);
            if (list == null) {
                fieldValues.add(null);
                rows.add(i);
                continue;
            }
            for (int j = 0; j < list.size(); ++j) {
                fieldValues.add(list.get(j));
                rows.add(i);
            }
        }
        int[] idx = Data.toPrimitive(rows.toArray(new Integer[rows.size()]));
        Field[] results = new Field[base.fields.length];
        for (int i = 0; i < results.length; ++i) {
            Field f = base.fields[i];
            if (f == target) {
                Object[] data = fieldValues.toArray(new Object[fieldValues.size()]);
                results[i] = Fields.makeColumnField(f.name, f.label, data);
                continue;
            }
            results[i] = Fields.permute(f, idx, false);
        }
        return base.replaceFields(results);
    }
}

