/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.data.modify;

import java.util.ArrayList;
import java.util.Collections;
import org.brunel.data.Data;
import org.brunel.data.Dataset;
import org.brunel.data.Field;
import org.brunel.data.Fields;
import org.brunel.data.modify.DataOperation;

public class ConvertSeries
extends DataOperation {
    public static Dataset transform(Dataset base, String commands) {
        if (commands.isEmpty()) {
            return base;
        }
        String[] sections = ConvertSeries.strings(commands, ';');
        Object[] yFields = ConvertSeries.strings(sections[0], ',');
        int nY = yFields.length;
        int nR = base.rowCount();
        if (nY < 2) {
            return base;
        }
        String items = sections.length < 2 ? "" : sections[1];
        String[] otherFields = ConvertSeries.addRequired(ConvertSeries.strings(items, ','));
        Field[] y = new Field[nY];
        for (int i = 0; i < nY; ++i) {
            y[i] = base.field(yFields[i]);
            if (y[i] != null) continue;
            throw new NullPointerException("ConvertSeries Could not find field for name: " + yFields[i]);
        }
        int[] seriesIndexing = new int[nY * nR];
        int[] valuesIndexing = new int[nY * nR];
        Object[] data = new Object[nY * nR];
        for (int i = 0; i < nY; ++i) {
            for (int j = 0; j < nR; ++j) {
                seriesIndexing[i * nR + j] = i;
                valuesIndexing[i * nR + j] = j;
                data[i * nR + j] = y[i].value(j);
            }
        }
        Field values = Fields.makeColumnField("#values", Data.join(yFields), data);
        Fields.copyBaseProperties(y[0], values);
        Field temp = Fields.makeColumnField("#series", "Series", yFields);
        Field series = Fields.permute(temp, seriesIndexing, false);
        series.setCategories(yFields);
        ArrayList<Field> resultFields = new ArrayList<Field>();
        resultFields.add(series);
        resultFields.add(values);
        for (String fieldName : otherFields) {
            if (fieldName.equals("#series") || fieldName.equals("#values")) continue;
            Field f = base.field(fieldName);
            resultFields.add(Fields.permute(f, valuesIndexing, false));
        }
        Field[] fields = resultFields.toArray(new Field[resultFields.size()]);
        return base.replaceFields(fields);
    }

    private static String[] addRequired(String[] list) {
        ArrayList<String> result = new ArrayList<String>();
        Collections.addAll(result, list);
        if (!result.contains("#row")) {
            result.add("#row");
        }
        if (!result.contains("#count")) {
            result.add("#count");
        }
        return result.toArray(new String[result.size()]);
    }
}

