/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.util;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.brunel.build.d3.D3Builder;

public class PageOutput {
    private final D3Builder builder;
    private final PrintWriter out;
    private final List<String> titleList;
    private final List<String> footerList;
    private String pageTitle;

    public PageOutput(D3Builder builder, Writer writer) {
        this.out = new PrintWriter(writer);
        this.builder = builder;
        this.titleList = new ArrayList<String>();
        this.footerList = new ArrayList<String>();
        this.pageTitle = "Brunel Output";
    }

    public PageOutput pageTitle(String name) {
        this.pageTitle = name;
        return this;
    }

    public PageOutput addTitles(String ... names) {
        Collections.addAll(this.titleList, names);
        return this;
    }

    public PageOutput addFooters(String ... names) {
        Collections.addAll(this.footerList, names);
        return this;
    }

    public PageOutput write() {
        String[] formattedTitles;
        String css = this.builder.getStyleOverrides();
        this.writeSection(Section.documentStart, "<!DOCTYPE html>", "<html lang=\"en\">");
        this.writeSection(Section.headStart, "<head>", "\t<meta charset=\"UTF-8\">", "\t<meta http-Equiv=\"Cache-Control\" Content=\"no-cache\">", "\t<meta http-Equiv=\"Pragma\" Content=\"no-cache\">", "\t<meta http-Equiv=\"Expires\" Content=\"0\">", "\t<title>" + PageOutput.escapeHTML(this.pageTitle) + "</title>");
        this.writeSection(Section.imports, this.builder.makeImports());
        this.writeSection(Section.stylesheets, this.builder.makeStyleSheets());
        if (!css.isEmpty()) {
            String[] lines = css.split("\n");
            ArrayList<String> complete = new ArrayList<String>();
            complete.add("\t<style>\t\t/* Generated by Brunel style commands */");
            for (String line : lines) {
                if (line == null || line.isEmpty()) continue;
                complete.add("\t\t" + line);
            }
            complete.add("\t</style>");
            this.writeSection(Section.styleOverrides, complete);
        }
        this.writeSection(Section.headEnd, "</head>");
        this.writeSection(Section.bodyStart, "<body style=\"margin:0\">");
        if (!this.titleList.isEmpty()) {
            formattedTitles = new String[this.titleList.size()];
            for (int i = 0; i < formattedTitles.length; ++i) {
                formattedTitles[i] = this.format(this.titleList.get(i), i == 0 ? "h2" : "p");
            }
            this.writeSection(Section.titles, formattedTitles);
        }
        this.writeSection(Section.svgItem, "<svg id=\"visualization\" width=\"" + this.builder.visWidth + "\" height=\"" + this.builder.visHeight + "\"></svg>");
        if (this.builder.getControls().isNeeded()) {
            this.writeSection(Section.controls, "<div id=\"controls\" class=\"brunel\"></div>");
        }
        if (!this.footerList.isEmpty()) {
            formattedTitles = new String[this.footerList.size()];
            for (int i = 0; i < formattedTitles.length; ++i) {
                formattedTitles[i] = this.format(this.footerList.get(i), "p");
            }
            this.writeSection(Section.titles, formattedTitles);
        }
        this.writeSection(Section.bodyEnd, "</body>");
        this.writeSection(Section.scriptStart, "<script>");
        this.writeSection(Section.brunel, this.builder.getVisualization());
        this.writeSection(Section.scriptEnd, "</script>");
        return this;
    }

    private String format(String s, String tag) {
        if ((s = s.trim()).startsWith("<") && s.endsWith(">")) {
            return s;
        }
        return "<" + tag + ">" + PageOutput.escapeHTML(s) + "</" + tag + ">";
    }

    protected void writeSection(Section section, String ... lines) {
        for (String content : lines) {
            this.out.println(content);
        }
    }

    private final void writeSection(Section section, List<String> lines) {
        this.writeSection(section, lines.toArray(new String[lines.size()]));
    }

    public static String escapeHTML(String s) {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c > '\u007f' || c == '\"' || c == '<' || c == '>' || c == '&') {
                b.append("&#");
                b.append((int)c);
                b.append(';');
                continue;
            }
            b.append(c);
        }
        return b.toString();
    }

    public static enum Section {
        documentStart,
        headStart,
        imports,
        stylesheets,
        styleOverrides,
        headEnd,
        bodyStart,
        titles,
        svgItem,
        controls,
        footer,
        bodyEnd,
        scriptStart,
        brunel,
        scriptEnd,
        documentEnd;

    }
}

