/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.brunel.action.Param;
import org.brunel.build.util.DataCache;
import org.brunel.data.Dataset;
import org.brunel.data.Field;
import org.brunel.model.VisException;
import org.brunel.model.VisItem;
import org.brunel.model.VisTypes;
import org.brunel.model.style.StyleFactory;
import org.brunel.model.style.StyleSheet;

public class VisSingle
extends VisItem
implements Cloneable {
    public StyleSheet styles;
    public Param[] bounds;
    public VisTypes.Coordinates coords;
    public List<Param> fColor;
    public List<Param> fSize;
    public List<Param> fOpacity;
    public List<Param> fFilter;
    public List<Param> fSort;
    public List<Param> fSplits;
    public List<Param> fX;
    public List<Param> fY;
    public Map<Param, String> fTransform;
    public Map<Param, String> fSummarize;
    public Param[] fRange;
    public List<Param> itemsTitle;
    public List<Param> itemsLabel;
    public List<Param> itemsTooltip;
    public boolean stacked;
    public VisTypes.Using tUsing;
    public VisTypes.Diagram tDiagram;
    public Param[] tDiagramParameters;
    public VisTypes.Element tElement;
    public VisTypes.Legends tLegends;
    public boolean flipX;
    public boolean flipY;
    public List<Param> fKeys;
    public List<Param> fEffects;
    public Param fData;
    public Map<VisTypes.Axes, Param[]> fAxes;
    public Map<VisTypes.Interaction, Param> tInteraction;
    private Dataset dataset;
    private String[] used;
    private String[] includingFilters;
    private String[] aesthetics;
    private String[] pos;
    private String[] nonPos;

    public VisSingle() {
        this(null);
    }

    public String toString() {
        return (this.tElement == null ? "element" : this.tElement) + "[" + this.fX.size() + "x" + this.fY.size() + "]";
    }

    public VisSingle(Dataset base) {
        this.dataset = base;
        this.coords = VisTypes.Coordinates.regular;
        this.coords = VisTypes.Coordinates.regular;
        this.tUsing = VisTypes.Using.none;
        this.tLegends = VisTypes.Legends.auto;
        this.tInteraction = Collections.EMPTY_MAP;
        this.fAxes = Collections.EMPTY_MAP;
        this.fX = Collections.EMPTY_LIST;
        this.fY = Collections.EMPTY_LIST;
        this.fColor = Collections.EMPTY_LIST;
        this.fKeys = Collections.EMPTY_LIST;
        this.fOpacity = Collections.EMPTY_LIST;
        this.fSize = Collections.EMPTY_LIST;
        this.fSort = Collections.EMPTY_LIST;
        this.fFilter = Collections.EMPTY_LIST;
        this.fSplits = Collections.EMPTY_LIST;
        this.fEffects = Collections.EMPTY_LIST;
        this.itemsLabel = Collections.EMPTY_LIST;
        this.itemsTitle = Collections.EMPTY_LIST;
        this.itemsTooltip = Collections.EMPTY_LIST;
        this.fTransform = Collections.EMPTY_MAP;
        this.fSummarize = Collections.EMPTY_MAP;
    }

    public String[] aestheticFields() {
        if (this.aesthetics == null) {
            this.makeUsedFields();
        }
        return this.aesthetics;
    }

    public void at(Param ... locations) {
        this.bounds = locations;
    }

    public void axes(Param ... options) {
        for (Param p : options) {
            if (p == null) {
                return;
            }
            if (this.fAxes.isEmpty()) {
                this.fAxes = new LinkedHashMap<VisTypes.Axes, Param[]>();
            }
            VisTypes.Axes t = VisTypes.Axes.valueOf(p.asString());
            this.fAxes.put(t, p.modifiers());
        }
    }

    public void transform(String type, Param[] fieldNames) {
        if (this.fTransform.isEmpty()) {
            this.fTransform = new LinkedHashMap<Param, String>();
        }
        for (Param param : fieldNames) {
            this.fTransform.put(param, type);
        }
    }

    public Dataset getDataset() {
        if (this.dataset == null) {
            if (this.fData == null) {
                this.dataset = Dataset.make((Field[])new Field[0], (Boolean)false);
            } else {
                try {
                    this.dataset = DataCache.get(this.fData.asString());
                }
                catch (IOException e) {
                    throw VisException.makeBuilding(e, this);
                }
            }
        }
        return this.dataset;
    }

    public void color(Param ... fieldNames) {
        if (this.fColor.isEmpty()) {
            this.fColor = new ArrayList<Param>(fieldNames.length);
        }
        Collections.addAll(this.fColor, fieldNames);
    }

    public void diagram(VisTypes.Diagram type, Param[] parameters) {
        this.tDiagram = type;
        this.tDiagramParameters = parameters;
    }

    public void element(VisTypes.Element e) {
        this.tElement = e;
    }

    public void data(Param dataReference) {
        this.dataset = null;
        this.fData = dataReference;
    }

    public void filter(Param ... fieldNames) {
        if (this.fFilter.isEmpty()) {
            this.fFilter = new ArrayList<Param>(fieldNames.length);
        }
        Collections.addAll(this.fFilter, fieldNames);
    }

    public void flip() {
        this.flipY = !this.flipY;
    }

    public void flipx() {
        this.flipX = !this.flipX;
    }

    public void interaction(Param ... types) {
        if (this.tInteraction.isEmpty()) {
            this.tInteraction = new LinkedHashMap<VisTypes.Interaction, Param>();
        }
        for (Param a : types) {
            VisTypes.Interaction option = VisTypes.Interaction.valueOf(a.asString());
            if (option == VisTypes.Interaction.auto || option == VisTypes.Interaction.none) {
                this.tInteraction.clear();
            }
            this.tInteraction.put(option, a);
        }
    }

    public void key(Param ... fieldNames) {
        if (this.fKeys.isEmpty()) {
            this.fKeys = new ArrayList<Param>(fieldNames.length);
        }
        Collections.addAll(this.fKeys, fieldNames);
    }

    public void label(Param ... items) {
        if (this.itemsLabel.isEmpty()) {
            this.itemsLabel = new ArrayList<Param>();
        }
        Collections.addAll(this.itemsLabel, items);
    }

    public void title(Param ... items) {
        if (this.itemsTitle.isEmpty()) {
            this.itemsTitle = new ArrayList<Param>();
        }
        Collections.addAll(this.itemsTitle, items);
    }

    public void legends(Param type) {
        if (type != null) {
            this.tLegends = VisTypes.Legends.valueOf(type.asString());
        }
    }

    @Override
    public VisSingle getSingle() {
        return this;
    }

    @Override
    public VisItem[] children() {
        return null;
    }

    @Override
    public String validate() {
        Field x;
        boolean elementNeeds2Fields = this.tElement == VisTypes.Element.area || this.tElement == VisTypes.Element.line;
        boolean diagramNeeds2Fields = this.tDiagram == VisTypes.Diagram.chord;
        int fields = this.fX.size() + this.fY.size() + (this.fRange == null ? 0 : 1);
        String error = null;
        if (elementNeeds2Fields && fields < 2) {
            error = this.addError(null, "Element used requires two fields");
        }
        if (diagramNeeds2Fields && fields < 2) {
            error = this.addError(error, "Diagram used requires two fields");
        }
        if (this.duplicatesWithin(this.fX)) {
            error = this.addError(error, "X contains duplicate fields");
        }
        if (this.duplicatesWithin(this.fColor)) {
            error = this.addError(error, "color contains duplicate fields");
        }
        if (this.duplicatesWithin(this.fFilter)) {
            error = this.addError(error, "filter contains duplicate fields");
        }
        if (this.duplicatesWithin(this.fSplits)) {
            error = this.addError(error, "splits contains duplicate fields");
        }
        if (this.tDiagram != null && this.stacked) {
            error = this.addError(error, "diagrams cannot be stacked");
        }
        Dataset dataset = this.getDataset();
        if (this.fX.size() > 1 && this.tElement != VisTypes.Element.edge && !(x = dataset.field(this.fX.get(0).asField(dataset))).preferCategorical()) {
            boolean isBinned = false;
            for (Map.Entry<Param, String> e : this.fTransform.entrySet()) {
                if (!e.getValue().equals("bin") || !e.getKey().asField(dataset).equals(x.name)) continue;
                isBinned = true;
            }
            if (!isBinned) {
                error = this.addError(error, "when using multiple x fields, the first must be categorical or binned");
            }
        }
        if (this.fY.size() < 2 && this.tDiagram != VisTypes.Diagram.network && this.containsSeriesField(this.usedFields(false))) {
            error = this.addError(error, "#series and #values can only be used when there are multiple Y fields");
        }
        if (this.fRange != null) {
            Field fY1 = dataset.field(this.fRange[0].asField(dataset));
            Field fY2 = dataset.field(this.fRange[1].asField(dataset));
            if (this.tElement == VisTypes.Element.path || this.tElement == VisTypes.Element.point || this.tElement == VisTypes.Element.polygon || this.tElement == VisTypes.Element.text) {
                error = this.addError(error, "Element '" + (Object)((Object)this.tElement) + "' should not be used with a y range");
            }
            if (fY1 != null && fY2 != null && fY1.preferCategorical() != fY2.preferCategorical()) {
                error = this.addError(error, "y range contains mix of categorical and non-categorical");
            }
        }
        return error;
    }

    @Override
    public Dataset[] getDataSets() {
        Dataset[] datasetArray;
        Dataset dataset = this.getDataset();
        if (dataset == null) {
            datasetArray = new Dataset[]{};
        } else {
            Dataset[] datasetArray2 = new Dataset[1];
            datasetArray = datasetArray2;
            datasetArray2[0] = dataset;
        }
        return datasetArray;
    }

    private String addError(String error, String toAdd) {
        return error == null ? toAdd : error + "; " + toAdd;
    }

    private boolean duplicatesWithin(List<Param> list) {
        for (int i = 1; i < list.size(); ++i) {
            for (int j = 0; j < i; ++j) {
                if (!list.get(i).equals(list.get(j))) continue;
                return true;
            }
        }
        return false;
    }

    private boolean containsSeriesField(String[] ff) {
        for (String f : ff) {
            if (!f.equals("#series") && !f.equals("#values")) continue;
            return true;
        }
        return false;
    }

    public String[] usedFields(boolean withFilters) {
        if (this.used == null) {
            this.makeUsedFields();
        }
        return withFilters ? this.includingFilters : this.used;
    }

    private void makeUsedFields() {
        ArrayList<String> posFields = new ArrayList<String>();
        this.addFieldNames(posFields, true, this.fX, this.fY);
        if (this.fRange != null) {
            Dataset dataset = this.getDataset();
            posFields.add(this.fRange[0].asField(dataset));
            posFields.add(this.fRange[1].asField(dataset));
        }
        this.pos = posFields.toArray(new String[posFields.size()]);
        LinkedHashSet<String> nonPosFields = new LinkedHashSet<String>();
        this.addFieldNames(nonPosFields, true, this.fColor, this.fSize, this.fOpacity, this.fSplits);
        if (nonPosFields.remove("#selection")) {
            nonPosFields.add("#selection");
        }
        this.aesthetics = nonPosFields.toArray(new String[nonPosFields.size()]);
        this.addFieldNames(nonPosFields, true, this.fSort, this.fKeys);
        this.addFieldNames(nonPosFields, false, this.itemsLabel, this.itemsTooltip);
        this.nonPos = nonPosFields.toArray(new String[nonPosFields.size()]);
        LinkedHashSet<String> all = new LinkedHashSet<String>();
        Collections.addAll(all, this.pos);
        Collections.addAll(all, this.nonPos);
        if (this.tInteraction.containsKey((Object)VisTypes.Interaction.filter)) {
            all.add("#selection");
        }
        this.addFields(all, this.fTransform.keySet());
        this.addFields(all, this.fSummarize.keySet());
        this.used = all.toArray(new String[all.size()]);
        this.addFieldNames(all, true, this.fFilter);
        this.includingFilters = all.toArray(new String[all.size()]);
    }

    private void addFields(Set<String> all, Set<Param> params) {
        for (Param p : params) {
            if (!p.isField()) continue;
            all.add(p.asField());
        }
    }

    private void addFieldNames(Collection<String> target, boolean forceToBeField, List<Param> ... sources) {
        for (List<Param> s : sources) {
            for (Param p : s) {
                String field;
                if (!p.isField() && !forceToBeField || (field = p.asField(this.getDataset())) == null) continue;
                target.add(field);
            }
        }
    }

    public void polar() {
        this.coords = VisTypes.Coordinates.polar;
    }

    public String[] positionFields() {
        if (this.pos == null) {
            this.makeUsedFields();
        }
        return this.pos;
    }

    public String[] nonPositionFields() {
        if (this.nonPos == null) {
            this.makeUsedFields();
        }
        return this.nonPos;
    }

    public VisSingle makeCanonical() {
        VisSingle result;
        boolean addY;
        this.ensureCanonical(this.fColor, "color");
        this.ensureCanonical(this.fSize, "size");
        this.ensureCanonical(this.fOpacity, "opacity");
        this.ensureCanonical(this.fFilter, "filter");
        this.ensureCanonical(this.fSort, "sort");
        this.ensureCanonical(this.fKeys, "key");
        this.ensureCanonical(this.fSplits, "split");
        this.ensureCanonical(this.fX, "x");
        this.ensureCanonical(this.fY, "y");
        this.ensureCanonical(this.itemsLabel, "label");
        this.ensureCanonical(this.itemsTooltip, "tooltip");
        this.ensureCanonical(this.fSummarize, "summarization");
        this.ensureCanonical(this.fTransform, "transform");
        this.makeUsedFields();
        LinkedHashSet<String> replacement = new LinkedHashSet<String>();
        for (String f : this.used) {
            if (f.equals("#all")) continue;
            replacement.add(f);
        }
        boolean containsAll = replacement.size() != this.used.length;
        boolean addSeriesSplit = false;
        boolean convertYsToRange = false;
        if (this.fY.size() > 1) {
            if (this.tElement == VisTypes.Element.edge) {
                convertYsToRange = true;
            } else if (this.tDiagram != VisTypes.Diagram.network) {
                addSeriesSplit = true;
                for (String s : this.aestheticFields()) {
                    if (!s.equals("#series")) continue;
                    addSeriesSplit = false;
                }
            }
        }
        boolean bl = addY = this.stacked && this.fY.isEmpty() && this.fRange == null;
        if (!(this.tElement == null || addY || containsAll || addSeriesSplit || convertYsToRange)) {
            return this;
        }
        try {
            result = (VisSingle)this.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new IllegalStateException(ex);
        }
        if (addSeriesSplit) {
            result.split(Param.makeField("#series"));
        }
        if (convertYsToRange) {
            result.fRange = new Param[]{this.fY.get(0), this.fY.get(1)};
            result.fY = Collections.emptyList();
        }
        if (this.tElement == null) {
            result.tElement = this.tDiagram != null ? this.tDiagram.defaultElement : (this.stacked ? VisTypes.Element.bar : VisTypes.Element.point);
        }
        if (containsAll) {
            result.fColor = this.replaceAllField(result.fColor, replacement);
            result.fSize = this.replaceAllField(result.fSize, replacement);
            result.fOpacity = this.replaceAllField(result.fOpacity, replacement);
            result.fFilter = this.replaceAllField(result.fFilter, replacement);
            result.fSort = this.replaceAllField(result.fSort, replacement);
            result.fKeys = this.replaceAllField(result.fKeys, replacement);
            result.fSplits = this.replaceAllField(result.fSplits, replacement);
            result.fX = this.replaceAllField(result.fX, replacement);
            result.fY = this.replaceAllField(result.fY, replacement);
            result.itemsLabel = this.replaceAllField(result.itemsLabel, replacement);
            result.itemsTitle = this.replaceAllField(result.itemsTitle, replacement);
            result.itemsTooltip = this.replaceAllField(result.itemsTooltip, replacement);
            result.fSummarize = this.replaceAllField(result.fSummarize, replacement);
            result.fTransform = this.replaceAllField(result.fTransform, replacement);
        }
        if (addY) {
            result.y(Param.makeNumber(1.0));
        }
        result.makeUsedFields();
        return result;
    }

    private void ensureCanonical(List<Param> list, String reason) {
        if (list.isEmpty()) {
            return;
        }
        Dataset dataset = this.getDataset();
        for (int i = 0; i < list.size(); ++i) {
            Param p = list.get(i);
            if (!p.isField()) continue;
            String name = p.asField(dataset);
            if (name == null) {
                NullPointerException cause = new NullPointerException(this.makeFieldErrorMessage(p, reason));
                throw VisException.makeBuilding(cause, this);
            }
            if (name.equals(p.asString())) continue;
            list.set(i, Param.makeField(name).addModifiers(p.modifiers()));
        }
    }

    private void ensureCanonical(Map<Param, String> map, String reason) {
        if (map.isEmpty()) {
            return;
        }
        Dataset dataset = this.getDataset();
        for (Param p : new ArrayList<Param>(map.keySet())) {
            if (!p.isField()) continue;
            String name = p.asField(dataset);
            if (name == null) {
                NullPointerException cause = new NullPointerException(this.makeFieldErrorMessage(p, reason));
                throw VisException.makeBuilding(cause, this);
            }
            if (dataset.field(name).isSynthetic() || name.equals(p.asString())) continue;
            Param newParameter = Param.makeField(name).addModifiers(p.modifiers());
            map.put(newParameter, map.get(p));
            map.remove(p);
        }
    }

    private String makeFieldErrorMessage(Param p, String reason) {
        return "Could not find the " + reason + " field '" + p.asField() + "'";
    }

    private List<Param> replaceAllField(List<Param> items, LinkedHashSet<String> replacementFieldNames) {
        if (items.isEmpty()) {
            return items;
        }
        Dataset dataset = this.getDataset();
        LinkedHashSet<String> itemFields = new LinkedHashSet<String>();
        Param allParam = null;
        for (Param p : items) {
            if (!p.isField()) continue;
            String s = p.asField(dataset);
            if (s.equals("#all")) {
                allParam = p;
                continue;
            }
            itemFields.add(s);
        }
        if (allParam == null) {
            return items;
        }
        ArrayList<Param> replacement = new ArrayList<Param>();
        for (String s : replacementFieldNames) {
            if (itemFields.contains(s)) continue;
            replacement.add(Param.makeField(s).addModifiers(allParam.modifiers()));
        }
        ArrayList<Param> result = new ArrayList<Param>();
        for (Param p : items) {
            if (p.asField(dataset).equals("#all")) {
                result.addAll(replacement);
                continue;
            }
            result.add(p);
        }
        return result;
    }

    private Map<Param, String> replaceAllField(Map<Param, String> items, LinkedHashSet<String> replacementFieldNames) {
        if (items.isEmpty()) {
            return items;
        }
        Dataset data = this.getDataset();
        LinkedHashSet<String> itemFields = new LinkedHashSet<String>();
        Param allParam = null;
        for (Param p : items.keySet()) {
            if (!p.isField()) continue;
            String s = p.asField(data);
            if (s.equals("#all")) {
                allParam = p;
                continue;
            }
            itemFields.add(s);
        }
        if (allParam == null) {
            return items;
        }
        ArrayList<Param> replacement = new ArrayList<Param>();
        for (String s : replacementFieldNames) {
            if (itemFields.contains(s)) continue;
            replacement.add(Param.makeField(s).addModifiers(allParam.modifiers()));
        }
        LinkedHashMap<Param, String> result = new LinkedHashMap<Param, String>();
        for (Map.Entry<Param, String> o : items.entrySet()) {
            Param p = o.getKey();
            String value = o.getValue();
            if (p.asField(data).equals("#all")) {
                for (Param s : replacement) {
                    result.put(s, value);
                }
                continue;
            }
            result.put(p, value);
        }
        return result;
    }

    public void size(Param ... fieldNames) {
        if (this.fSize.isEmpty()) {
            this.fSize = new ArrayList<Param>(fieldNames.length);
        }
        Collections.addAll(this.fSize, fieldNames);
    }

    public void opacity(Param ... fieldNames) {
        if (this.fOpacity.isEmpty()) {
            this.fOpacity = new ArrayList<Param>(fieldNames.length);
        }
        Collections.addAll(this.fOpacity, fieldNames);
    }

    public void sort(Param ... fieldNames) {
        if (this.fSort.isEmpty()) {
            this.fSort = new ArrayList<Param>(fieldNames.length);
        }
        Collections.addAll(this.fSort, fieldNames);
    }

    public void effects(Param ... effectNames) {
        if (this.fEffects.isEmpty()) {
            this.fEffects = new ArrayList<Param>(effectNames.length);
        }
        Collections.addAll(this.fEffects, effectNames);
    }

    public void split(Param ... fieldNames) {
        if (this.fSplits.isEmpty()) {
            this.fSplits = new ArrayList<Param>(fieldNames.length);
        }
        Collections.addAll(this.fSplits, fieldNames);
    }

    public void stack() {
        this.stacked = true;
    }

    public void style(Param style) {
        String text = style.asString();
        if (!text.contains("{")) {
            text = ".currentElement .element {" + text + "}";
        }
        StyleSheet sheet = StyleFactory.instance().makeStyleSheet(text);
        if (this.styles == null) {
            this.styles = sheet;
        } else {
            this.styles.add(sheet, new String[0]);
        }
    }

    public void summarize(String method, Param ... fieldNames) {
        if (this.fSummarize.isEmpty()) {
            this.fSummarize = new LinkedHashMap<Param, String>();
        }
        for (Param fieldName : fieldNames) {
            this.fSummarize.put(fieldName, method);
        }
    }

    public void tooltip(Param ... items) {
        if (this.itemsTooltip.isEmpty()) {
            this.itemsTooltip = new ArrayList<Param>(items.length);
        }
        Collections.addAll(this.itemsTooltip, items);
    }

    public void transpose() {
        this.coords = VisTypes.Coordinates.transposed;
    }

    public void using(Param type) {
        this.tUsing = VisTypes.Using.valueOf(type.asString());
    }

    public void x(Param ... fieldNames) {
        if (this.fX.isEmpty()) {
            this.fX = new ArrayList<Param>(fieldNames.length);
        }
        Collections.addAll(this.fX, fieldNames);
    }

    public void y(Param ... fieldNames) {
        this.fRange = null;
        if (this.fY.isEmpty()) {
            this.fY = new ArrayList<Param>(fieldNames.length);
        }
        Collections.addAll(this.fY, fieldNames);
    }

    public void yrange(Param fieldA, Param fieldB) {
        this.fY = Collections.EMPTY_LIST;
        this.fRange = new Param[]{fieldA, fieldB};
    }
}

