/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.match;

import org.brunel.action.Action;
import org.brunel.action.ActionUtil;
import org.brunel.action.Param;
import org.brunel.match.ActionParameterChoice;
import org.brunel.match.ScoredChoice;

class ActionChoice
extends ScoredChoice {
    private final Action action;

    private ActionChoice(Action action, double score) {
        super(score);
        this.action = action;
    }

    public Action getAction() {
        return this.action;
    }

    public static ActionChoice makeActionChoice(Action originalAction, ActionParameterChoice[] chosenParms) {
        int size = chosenParms.length;
        double score = 1.0;
        Param[] parms = new Param[size];
        for (int i = 0; i < parms.length; ++i) {
            ActionParameterChoice c = chosenParms[i];
            parms[i] = c.getActionParameter();
            score *= c.getScore();
        }
        score = Math.pow(score, 1.0 / (double)size);
        return new ActionChoice(ActionUtil.replaceParameters(originalAction, parms), score);
    }
}

