/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.maps;

import java.text.Normalizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

class GeoNaming {
    private static final Pattern PATTERN = Pattern.compile("\\p{InCombiningDiacriticalMarks}+");
    private static final String MAPPING = "uk:united kingdom|britain:united kingdom|great britain:united kingdom|united states:united states of america|united states:united states of america|usa:united states of america|us:united states of america|unitedstatesofamerica:united states of america|burma:myanmar|vatican city:vatican";
    private static final Map<String, String> commonNames = new HashMap<String, String>();

    GeoNaming() {
    }

    public static String canonical(String s) {
        String common = commonNames.get(s = GeoNaming.removeAccents(s.toLowerCase()).replaceAll("\u2019", "'").replaceAll("`", "'").replaceAll(" +and +", " & ").replaceAll("  +", " "));
        if (common != null) {
            s = common;
        }
        s = s.replaceAll("[ \t]+", " ");
        if ((s = GeoNaming.expandAbbreviations(s.toLowerCase())).startsWith("united kingdom of")) {
            return "united kingdom";
        }
        if (s.startsWith("holy see")) {
            return "vatican";
        }
        return s;
    }

    private static String expandAbbreviations(String s) {
        return s.replaceAll("st\\.[ ]*", "saint ").replaceAll("dem\\.[ ]*", "democratic ").replaceAll("rep\\.[ ]*", "republic ").replaceAll("is\\.[ ]*", "islands ").replaceAll(" [ ]+", " ").trim();
    }

    private static String removeAccents(String s) {
        String decomposed = Normalizer.normalize(s, Normalizer.Form.NFD);
        return PATTERN.matcher(decomposed).replaceAll("");
    }

    private static String removePeriods(String s) {
        if (s.length() == 5 && s.charAt(2) == '.') {
            return s;
        }
        return s.replaceAll("\\.", "");
    }

    public static List<String> variants(String name) {
        int p;
        String t;
        ArrayList<String> variants = new ArrayList<String>();
        if (name.equals("east germany") || name.equals("west germany")) {
            variants.add("germany");
            return variants;
        }
        if (name.startsWith("us ")) {
            variants.add("united states" + name.substring(2));
        }
        if (!name.equals(t = GeoNaming.removeAccents(name))) {
            variants.add(t);
        }
        if (!name.equals(t = GeoNaming.removePeriods(name))) {
            variants.add(t);
        }
        if ((p = name.indexOf(44)) > 0) {
            variants.add(name.substring(p + 1).trim() + " " + name.substring(0, p));
            variants.add(name.substring(0, p));
        }
        if ((p = name.indexOf(40)) > 0) {
            variants.add(name.substring(0, p).trim());
        }
        if ((p = name.indexOf(" and ")) > 0) {
            variants.add(name.substring(0, p).trim());
            variants.add(name.substring(p + 5).trim());
        }
        if ((p = name.indexOf(" excl")) > 0) {
            variants.add(name.substring(0, p).trim());
        }
        return variants;
    }

    static {
        for (String s : MAPPING.split("\\|")) {
            String[] p = s.split(":");
            commonNames.put(p[0], p[1]);
        }
    }
}

