/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.maps;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.brunel.action.Param;
import org.brunel.data.io.CSV;
import org.brunel.geom.Point;
import org.brunel.maps.GeoFile;
import org.brunel.maps.GeoMapping;
import org.brunel.maps.GeoNaming;
import org.brunel.maps.IndexedFeature;
import org.brunel.maps.LabelPoint;
import org.brunel.util.MappedLists;

class GeoData {
    private static GeoData INSTANCE;
    private final Map<String, List<Feature>> featureMap;
    private final Map<String, GeoFile> filesByName;
    private final Map<String, LabelPoint> labelsByName;
    private final GeoFile[] geoFiles;

    public static synchronized GeoData instance() {
        if (INSTANCE == null) {
            INSTANCE = new GeoData();
        }
        return INSTANCE;
    }

    public static String getQuality(Param[] diagramParameters) {
        for (Param p : diagramParameters) {
            if (p.type() != Param.Type.option) continue;
            if (p.asString().equals("medium")) {
                return "med";
            }
            if (p.asString().equals("high")) {
                return "high";
            }
            if (!p.asString().equals("low")) continue;
            return "low";
        }
        return "med";
    }

    MappedLists<GeoFile, Object> mapFeaturesToFiles(Object[] names, Collection<Object> unmatched) {
        MappedLists<GeoFile, Object> contained = new MappedLists<GeoFile, Object>();
        for (Object s : names) {
            String key = s.toString();
            List<Feature> item = this.featureByName(key);
            if (item == null) {
                unmatched.add(s);
                continue;
            }
            for (Feature i : item) {
                contained.add(i.file, new IndexedFeature(key, i.id));
            }
        }
        return contained;
    }

    private GeoData() {
        try {
            InputStream is = GeoData.class.getResourceAsStream("/org/brunel/maps/geoinfo/featureFiles.txt");
            LineNumberReader rdr = new LineNumberReader(new InputStreamReader(is, "utf-8"));
            this.geoFiles = this.readFileDescriptions(rdr);
            this.filesByName = this.makeFileNameMap(this.geoFiles);
            is = GeoData.class.getResourceAsStream("/org/brunel/maps/geoinfo/featureDetails.txt");
            rdr = new LineNumberReader(new InputStreamReader(is, "utf-8"));
            this.featureMap = this.readFeatureDescriptions(rdr, this.filesByName);
            rdr.close();
            is = GeoData.class.getResourceAsStream("/org/brunel/maps/geoinfo/locations.txt");
            rdr = new LineNumberReader(new InputStreamReader(is, "utf-8"));
            this.labelsByName = GeoData.readLabels(rdr, this.filesByName);
            rdr.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.addVariantFeatureNames();
    }

    public List<Feature> featureByName(String s) {
        List<Feature> result = this.featureMap.get(s = GeoNaming.canonical(s));
        if (result != null) {
            return result;
        }
        for (String t : GeoNaming.variants(s)) {
            result = this.featureMap.get(t);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public GeoFile[] getGeoFiles() {
        return this.geoFiles;
    }

    private Map<String, GeoFile> makeFileNameMap(GeoFile[] geoFiles) {
        HashMap<String, GeoFile> map = new HashMap<String, GeoFile>();
        for (GeoFile s : geoFiles) {
            map.put(GeoNaming.canonical(s.name), s);
            map.put(GeoNaming.canonical(CSV.readable((String)s.name)), s);
        }
        return map;
    }

    private void addVariantFeatureNames() {
        ArrayList<String> keys = new ArrayList<String>(this.featureMap.keySet());
        for (String s : keys) {
            for (String t : GeoNaming.variants(s)) {
                if (this.featureMap.containsKey(t)) continue;
                this.featureMap.put(t, this.featureMap.get(s));
            }
        }
    }

    private static Map<String, LabelPoint> readLabels(LineNumberReader rdr, Map<String, GeoFile> filesByName) throws IOException {
        String line;
        HashMap<String, LabelPoint> result = new HashMap<String, LabelPoint>();
        while ((line = rdr.readLine()) != null) {
            String[] parts = line.split("\\|");
            LabelPoint point = LabelPoint.makeFromArray(parts);
            if (!result.containsKey(point.label)) {
                result.put(point.label, point);
            }
            for (int i = 5; i < parts.length; ++i) {
                String fileName = GeoNaming.canonical(parts[i]);
                GeoFile geoFile = filesByName.get(fileName);
                if (geoFile == null) {
                    throw new NullPointerException("Cannot find geo file named: " + fileName);
                }
                geoFile.pts.add(point);
            }
        }
        for (GeoFile f : filesByName.values()) {
            Collections.sort(f.pts);
        }
        return result;
    }

    private Map<String, List<Feature>> readFeatureDescriptions(LineNumberReader rdr, Map<String, GeoFile> filesByName) throws IOException {
        String line;
        HashMap<String, List<Feature>> map = new HashMap<String, List<Feature>>();
        while ((line = rdr.readLine()) != null) {
            String[] parts = line.split(",");
            GeoFile geoFile = filesByName.get(GeoNaming.canonical(parts[0]));
            int id = Integer.parseInt(parts[1]);
            if (geoFile == null) {
                throw new IllegalStateException("Unknown file name: " + parts[0]);
            }
            Feature data = new Feature(geoFile, id);
            for (int i = 2; i < parts.length; ++i) {
                String name = parts[i];
                List<Feature> list = map.get(name);
                if (list == null) {
                    list = new ArrayList<Feature>();
                    map.put(name, list);
                }
                list.add(data);
            }
        }
        return map;
    }

    private GeoFile[] readFileDescriptions(LineNumberReader rdr) throws IOException {
        String[] fileLine;
        ArrayList<GeoFile> list = new ArrayList<GeoFile>();
        while ((fileLine = rdr.readLine().split("\\|")).length == 4) {
            list.add(new GeoFile(fileLine[0], fileLine[1], fileLine[2]));
        }
        return list.toArray(new GeoFile[list.size()]);
    }

    public List<GeoFile> makeRequiredFiles(Param[] params) {
        HashSet<GeoFile> byFeature = new HashSet<GeoFile>();
        ArrayList<GeoFile> result = new ArrayList<GeoFile>();
        for (Param p : params) {
            if (p.type() == Param.Type.option) continue;
            String key = GeoNaming.canonical(p.asString());
            GeoFile f = this.filesByName.get(key);
            if (f != null) {
                result.add(f);
                continue;
            }
            List<Feature> features = this.featureMap.get(key);
            if (features != null) {
                byFeature.add(features.get((int)0).file);
                continue;
            }
            LabelPoint location = this.labelsByName.get(key);
            if (location == null) continue;
            byFeature.add(this.smallestFileContaining(location));
        }
        result.addAll(byFeature);
        return result.isEmpty() ? null : result;
    }

    private GeoFile smallestFileContaining(Point point) {
        GeoFile result = null;
        for (GeoFile g : this.geoFiles) {
            if (!g.covers(point) || result != null && !(g.bounds.area() < result.bounds.area())) continue;
            result = g;
        }
        return result;
    }

    GeoMapping make(Object[] names, Param[] geoParameters) {
        return GeoMapping.createGeoMapping(names, GeoData.instance().makeRequiredFiles(geoParameters), this, GeoData.getQuality(geoParameters), null);
    }

    private static class Feature {
        final GeoFile file;
        final int id;

        private Feature(GeoFile file, int id) {
            this.file = file;
            this.id = id;
        }
    }
}

