/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.geom;

import java.util.Collection;
import org.brunel.geom.Geom;
import org.brunel.geom.Point;
import org.brunel.geom.Rect;

public class Poly {
    public final Point[] points;
    public final Rect bounds;

    public Poly(Collection<Point> points) {
        this(points.toArray(new Point[points.size()]));
    }

    public Poly(Point ... points) {
        this.points = points;
        this.bounds = Geom.bounds(points);
    }

    public final int count() {
        return this.points.length;
    }

    public double distanceToBoundary(Point p) {
        int n = this.points.length;
        double dSq = Double.POSITIVE_INFINITY;
        for (Point q : this.points) {
            dSq = Math.min(dSq, p.dist2(q));
        }
        if (dSq < 1.0E-10) {
            return 0.0;
        }
        int j = n - 1;
        int i = 0;
        while (i < n) {
            double t = Geom.segmentPerpendicularDistanceSquared(p, this.points[i], this.points[j]);
            if (t < dSq && (dSq = t) < 1.0E-10) {
                return 0.0;
            }
            j = i++;
        }
        return Math.sqrt(dSq);
    }

    public boolean contains(Point p) {
        if (!this.bounds.contains(p)) {
            return false;
        }
        int intersectCountLeft = 0;
        int n = this.points.length;
        int j = n - 1;
        int i = 0;
        while (i < n) {
            Point qi = this.points[i];
            Point qj = this.points[j];
            double m = (qj.y - qi.y) / (qj.x - qi.x);
            if (!Double.isNaN(m) && Math.abs(m) != 0.0) {
                if (Math.abs(m) > 1.0E20) {
                    double intersectX = qi.x;
                    double intersectY = p.y;
                    if ((intersectY >= qi.y && intersectY <= qj.y || intersectY >= qj.y && intersectY <= qi.y) && intersectX < p.x) {
                        if (intersectY == qi.y) {
                            if (qj.y > p.y) {
                                ++intersectCountLeft;
                            }
                        } else if (intersectY == qj.y) {
                            if (qi.y > p.y) {
                                ++intersectCountLeft;
                            }
                        } else {
                            ++intersectCountLeft;
                        }
                    }
                } else {
                    double b = qi.y - m * qi.x;
                    double intersectX = (p.y - b) / m;
                    if ((intersectX >= qi.x && intersectX <= qj.x || intersectX >= qj.x && intersectX <= qi.x) && intersectX < p.x) {
                        if (p.y == qi.y) {
                            if (qj.y > p.y) {
                                ++intersectCountLeft;
                            }
                        } else if (p.y == qj.y) {
                            if (qi.y > p.y) {
                                ++intersectCountLeft;
                            }
                        } else {
                            ++intersectCountLeft;
                        }
                    }
                }
            }
            j = i++;
        }
        return intersectCountLeft % 2 != 0;
    }
}

