/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.build.util;

public class BuilderOptions {
    public String visIdentifier = "visualization";
    public String controlsIdentifier = "controls";
    public String dataName = "table%d";
    public String className = "BrunelVis";
    public DataMethod includeData = DataMethod.columns;
    public boolean generateBuildCode = true;
    public boolean readableJavascript = true;
    public String locJavaScript = "https://brunelvis.org/js";
    public String locMaps = "https://brunelvis.org/geo";
    public String locD3 = "//cdnjs.cloudflare.com/ajax/libs/d3/3.5.5/d3.min";
    public String locTopoJson = "//cdnjs.cloudflare.com/ajax/libs/topojson/1.6.20/topojson.min";
    public String version = "1.2";

    public static BuilderOptions make(String[] args) {
        BuilderOptions options = new BuilderOptions();
        for (int i = 0; i < args.length - 1; ++i) {
            String arg = args[i].toLowerCase();
            if (arg.equals("-v") || arg.equals("-version")) {
                options.version = args[i + 1];
            }
            if (arg.equals("-js") || arg.equals("-javascript")) {
                options.locJavaScript = args[i + 1];
            }
            if (!arg.equals("-m") && !arg.equals("-maps")) continue;
            options.locMaps = args[i + 1];
        }
        return options;
    }

    public static BuilderOptions makeFromENV() {
        String[] configs;
        BuilderOptions options = new BuilderOptions();
        String config = System.getenv("BRUNEL_CONFIG");
        if (config == null) {
            return options;
        }
        for (String c : configs = config.split(";")) {
            String[] keyVal = c.trim().split("=");
            if (keyVal[0].trim().equalsIgnoreCase("locJavaScript")) {
                options.locJavaScript = keyVal[1].trim();
                continue;
            }
            if (keyVal[0].trim().equalsIgnoreCase("locMaps")) {
                options.locMaps = keyVal[1].trim();
                continue;
            }
            if (keyVal[0].trim().equalsIgnoreCase("locD3")) {
                options.locD3 = keyVal[1].trim();
                continue;
            }
            if (!keyVal[0].trim().equalsIgnoreCase("locTopoJson")) continue;
            options.locTopoJson = keyVal[1].trim();
        }
        return options;
    }

    public static enum DataMethod {
        none,
        full,
        columns,
        minimal;

    }
}

