/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.build.info;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.brunel.action.Param;
import org.brunel.build.util.ModelUtil;
import org.brunel.data.Dataset;
import org.brunel.data.Field;
import org.brunel.data.auto.Auto;
import org.brunel.model.VisSingle;

public class ChartCoordinates {
    public final Field[] allXFields;
    public final Field[] allYFields;
    public final Field[] allXClusterFields;
    public final String xTransform;
    public final String yTransform;
    public final boolean xCategorical;
    public final boolean yCategorical;
    private final Map<VisSingle, Field[]> x = new HashMap<VisSingle, Field[]>();
    private final Map<VisSingle, Field[]> y = new HashMap<VisSingle, Field[]>();

    public ChartCoordinates(VisSingle[] elements, Dataset[] elementData) {
        String xTransform = null;
        String yTransform = null;
        ArrayList<Field> allX = new ArrayList<Field>();
        ArrayList allY = new ArrayList();
        ArrayList<Field> allCluster = new ArrayList<Field>();
        for (int i = 0; i < elements.length; ++i) {
            Field[] visXFields = this.getXFields(elements[i], elementData[i]);
            Field[] visYFields = this.getYFields(elements[i], elementData[i]);
            if (xTransform == null) {
                xTransform = this.getDefinedXTransform(elements[i]);
            }
            if (yTransform == null) {
                yTransform = this.getDefinedYTransform(elements[i]);
            }
            this.x.put(elements[i], visXFields);
            this.y.put(elements[i], visYFields);
            if (visXFields.length > 0) {
                allX.add(visXFields[0]);
            }
            if (visXFields.length > 1) {
                allCluster.add(visXFields[1]);
            }
            Collections.addAll(allY, visYFields);
        }
        this.allXFields = allX.toArray(new Field[allX.size()]);
        this.allYFields = allY.toArray(new Field[allY.size()]);
        this.allXClusterFields = allCluster.toArray(new Field[allCluster.size()]);
        this.xCategorical = ModelUtil.combinationIsCategorical(this.allXFields, true);
        this.yCategorical = ModelUtil.combinationIsCategorical(this.allYFields, true);
        this.xTransform = xTransform == null ? (this.xCategorical ? "linear" : this.chooseTransform(this.allXFields)) : xTransform;
        this.yTransform = yTransform == null ? (this.yCategorical ? "linear" : this.chooseTransform(this.allYFields)) : yTransform;
    }

    private Field[] getXFields(VisSingle vis, Dataset data) {
        Field[] result = new Field[vis.fX.size()];
        for (int i = 0; i < vis.fX.size(); ++i) {
            result[i] = data.field(vis.fX.get(i).asField());
        }
        return result;
    }

    private Field[] getYFields(VisSingle vis, Dataset data) {
        if (vis.fRange != null) {
            return new Field[]{data.field(vis.fRange[0].asField(data)), data.field(vis.fRange[1].asField(data))};
        }
        if (vis.fY.isEmpty()) {
            return new Field[0];
        }
        if (vis.fY.size() > 1) {
            if (vis.stacked) {
                return data.fieldArray(new String[]{"#values$lower", "#values$upper"});
            }
            return data.fieldArray(new String[]{"#values"});
        }
        String s = vis.fY.get(0).asField();
        if (vis.stacked) {
            return data.fieldArray(new String[]{s + "$lower", s + "$upper"});
        }
        return data.fieldArray(new String[]{s});
    }

    private String getDefinedXTransform(VisSingle v) {
        for (Param p : v.fX) {
            if (!p.isField() || !p.hasModifiers()) continue;
            return p.firstModifier().asString();
        }
        return null;
    }

    private String getDefinedYTransform(VisSingle v) {
        for (Param p : v.fY) {
            if (!p.isField() || !p.hasModifiers()) continue;
            return p.firstModifier().asString();
        }
        if (v.fRange != null) {
            if (v.fRange[0].isField() && v.fRange[0].hasModifiers()) {
                return v.fRange[0].firstModifier().asString();
            }
            if (v.fRange[1].isField() && v.fRange[1].hasModifiers()) {
                return v.fRange[1].firstModifier().asString();
            }
        }
        return null;
    }

    private String chooseTransform(Field[] fields) {
        if (fields.length == 0) {
            return "linear";
        }
        String best = "linear";
        double min = Double.MAX_VALUE;
        for (Field f : fields) {
            if (f.min() == null) continue;
            Auto.setTransform((Field)f);
            String s = f.strProperty("transform");
            if ("log".equals(s)) {
                best = "log";
            } else if ("root".equals(s) && !best.equals("log")) {
                best = "root";
            }
            if (!f.isNumeric()) continue;
            min = Math.min(min, f.min());
        }
        if ("log".equals(best) && min <= 0.0) {
            return "linear";
        }
        return best;
    }

    public Field[] getX(VisSingle vis) {
        return this.x.get(vis);
    }

    public Field[] getY(VisSingle vis) {
        return this.y.get(vis);
    }
}

