/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.build.d3.element;

import org.brunel.build.d3.D3Util;
import org.brunel.build.d3.element.ElementDetails;
import org.brunel.build.d3.element.ElementDimension;
import org.brunel.build.d3.element.ElementRepresentation;
import org.brunel.build.d3.element.GeomAttribute;
import org.brunel.build.info.ElementStructure;
import org.brunel.data.Field;
import org.brunel.model.VisTypes;

class DefineLocations {
    static final String CLUSTER_SPACING = "0.75";

    DefineLocations() {
    }

    private static String addClusterMultiplier(Field cluster) {
        if (DefineLocations.isRange(cluster)) {
            return " + clusterWidth * scale_inner(" + D3Util.writeCall(cluster) + ".mid)";
        }
        return " + clusterWidth * scale_inner(" + D3Util.writeCall(cluster) + ")";
    }

    static boolean isRange(Field field) {
        if (field.isBinned() && field.isNumeric()) {
            return true;
        }
        String s = field.strProperty("summary");
        return s != null && (s.equals("iqr") || s.equals("range"));
    }

    static void setDependentLocations(ElementStructure structure, ElementDetails details) {
        boolean geo;
        boolean bl = geo = structure.chart.geo != null;
        if (details.representation == ElementRepresentation.segment) {
            details.x.left = GeomAttribute.makeFunction(geo ? "this.r[0][0]" : "scale_x(this.r[0][0])");
            details.x.right = GeomAttribute.makeFunction(geo ? "this.r[1][0]" : "scale_x(this.r[1][0])");
            details.y.left = GeomAttribute.makeFunction(geo ? "this.r[0][1]" : "scale_y(this.r[0][1])");
            details.y.right = GeomAttribute.makeFunction(geo ? "this.r[1][1]" : "scale_y(this.r[1][1])");
        } else {
            details.x.center = GeomAttribute.makeFunction(geo ? "this.r[0][0]" : "scale_x(this.r[0][0])");
            details.y.center = GeomAttribute.makeFunction(geo ? "this.r[0][1]" : "scale_y(this.r[0][1])");
        }
    }

    static void setLocations(ElementRepresentation rep, ElementStructure structure, ElementDimension dim, String dimName, Field[] fields, boolean categorical) {
        boolean useRangesFromBins;
        String scaleName = "scale_" + dimName;
        if (structure.isGraphEdge()) {
            dim.left = GeomAttribute.makeFunction("d.source." + dimName);
            dim.right = GeomAttribute.makeFunction("d.target." + dimName);
            return;
        }
        if (structure.dependent) {
            return;
        }
        if (fields.length == 0) {
            if (rep == ElementRepresentation.rect) {
                dim.left = GeomAttribute.makeConstant(scaleName + ".range()[0]");
                dim.right = GeomAttribute.makeConstant(scaleName + ".range()[1]");
            } else {
                dim.center = GeomAttribute.makeConstant(scaleName + "(0.5)");
            }
            return;
        }
        Field main = fields[0];
        boolean bl = useRangesFromBins = main.isBinned() && !categorical;
        if (dimName.equals("x") && rep != ElementRepresentation.rect) {
            useRangesFromBins = false;
        }
        if (DefineLocations.defineForTwoFields(rep, dimName, fields)) {
            String lowDataFunc = D3Util.writeCall(main);
            String highDataFunc = D3Util.writeCall(fields[1]);
            if (DefineLocations.isRange(main)) {
                lowDataFunc = lowDataFunc + ".low";
            }
            if (DefineLocations.isRange(fields[1])) {
                highDataFunc = highDataFunc + ".high";
            }
            dim.left = GeomAttribute.makeFunction(scaleName + "(" + lowDataFunc + ")");
            dim.right = GeomAttribute.makeFunction(scaleName + "(" + highDataFunc + ")");
            dim.center = GeomAttribute.makeFunction(scaleName + "( (" + highDataFunc + " + " + lowDataFunc + " )/2)");
        } else {
            Field cluster = fields.length > 1 ? fields[1] : null;
            String dataFunction = D3Util.writeCall(main);
            if (useRangesFromBins) {
                if (cluster == null) {
                    dim.center = GeomAttribute.makeFunction(scaleName + "(" + dataFunction + ".mid)");
                    dim.left = GeomAttribute.makeFunction(scaleName + "(" + dataFunction + ".low)");
                    dim.right = GeomAttribute.makeFunction(scaleName + "(" + dataFunction + ".high)");
                } else {
                    String L = scaleName + "(" + dataFunction + ".low)";
                    String R = scaleName + "(" + dataFunction + ".high)";
                    String D = DefineLocations.isRange(cluster) ? "scale_inner(" + D3Util.writeCall(cluster) + ".mid)" : "scale_inner(" + D3Util.writeCall(cluster) + ")";
                    dim.center = GeomAttribute.makeFunction("BrunelD3.interpolate(" + L + ", " + R + ", " + CLUSTER_SPACING + " * " + D + ")");
                }
            } else if (DefineLocations.isRange(main)) {
                String def = scaleName + "(" + dataFunction + ".mid)";
                if (cluster != null) {
                    def = def + DefineLocations.addClusterMultiplier(cluster);
                }
                dim.center = GeomAttribute.makeFunction(def);
            } else if (structure.vis.tElement == VisTypes.Element.bar && dimName.equals("y")) {
                dim.right = GeomAttribute.makeFunction(scaleName + "(" + dataFunction + ")");
                dim.left = GeomAttribute.makeConstant(scaleName + ".range()[0]");
            } else {
                String def = scaleName + "(" + dataFunction + ")";
                if (cluster != null) {
                    def = def + DefineLocations.addClusterMultiplier(cluster);
                }
                dim.center = GeomAttribute.makeFunction(def);
            }
        }
    }

    private static boolean defineForTwoFields(ElementRepresentation rep, String dimName, Field[] fields) {
        if (fields.length < 2) {
            return false;
        }
        return dimName.equals("y") || rep == ElementRepresentation.segment;
    }
}

