/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.build.d3.diagrams;

import org.brunel.build.d3.D3Interaction;
import org.brunel.build.d3.diagrams.D3Diagram;
import org.brunel.build.d3.element.ElementDetails;
import org.brunel.build.d3.element.ElementRepresentation;
import org.brunel.build.info.ElementStructure;
import org.brunel.build.util.ScriptWriter;
import org.brunel.data.Dataset;
import org.brunel.model.VisSingle;

class Network
extends D3Diagram {
    private final ElementStructure nodes;
    private final ElementStructure edges;
    private final String nodeID;
    private final String fromFieldID;
    private final String toFieldID;

    public Network(VisSingle vis, Dataset data, ElementStructure nodes, ElementStructure edges, D3Interaction interaction, ScriptWriter out) {
        super(vis, data, interaction, out);
        this.nodes = nodes;
        this.edges = edges;
        if (vis.fKeys.size() > 0) {
            this.nodeID = vis.fKeys.get(0).asField(nodes.data);
        } else if (vis.fY.size() > 1) {
            this.nodeID = "#values";
        } else if (vis.positionFields().length > 0) {
            this.nodeID = vis.positionFields()[0];
        } else {
            throw new IllegalStateException("Networks require nodes to have a key field or position field");
        }
        VisSingle edgesVis = edges.vis;
        if (edgesVis.fKeys.size() > 1) {
            this.fromFieldID = edgesVis.fKeys.get(0).asField(edges.data);
            this.toFieldID = edgesVis.fKeys.get(1).asField(edges.data);
        } else if (edgesVis.positionFields().length > 1) {
            this.fromFieldID = edgesVis.positionFields()[0];
            this.toFieldID = edgesVis.positionFields()[1];
        } else {
            throw new IllegalStateException("Networks require edges to have two key fields or position fields");
        }
    }

    @Override
    public void writeBuildCommands() {
        String density = "";
        if (this.vis.tDiagramParameters.length > 0) {
            density = ", " + this.vis.tDiagramParameters[0].asDouble();
        }
        this.out.onNewLine().add("if (first) ").add("BrunelD3.network(d3.layout.force(), graph, elements[" + this.nodes.index + "], elements[" + this.edges.index + "], geom" + density + ")").endStatement();
    }

    @Override
    public void writePerChartDefinitions() {
        this.out.add("var graph;").at(50).comment("Graph used for nodes and links");
    }

    @Override
    public ElementDetails initializeDiagram() {
        String edgeDataset = "elements[" + this.edges.getBaseDatasetIndex() + "].data()";
        String nodeField = this.quoted(this.nodeID);
        String from = this.quoted(this.fromFieldID);
        String to = this.quoted(this.toFieldID);
        this.out.add("graph = BrunelData.diagram_Graph.make(processed,", nodeField, ",", edgeDataset, ",", from, ",", to, ")").endStatement();
        this.out.ln();
        this.makeLayout();
        this.out.ln();
        return ElementDetails.makeForDiagram(this.vis, ElementRepresentation.largeCircle, "point", "graph.nodes");
    }

    private void makeLayout() {
        this.out.comment("Initial Circle Layout").add("var h = geom.inner_width/2, v = geom.inner_height/2, a, i, N = graph.nodes.length").endStatement().add("for(i=0; i<N; i++) { a = Math.PI*2*i/N; graph.nodes[i].x = h + h*Math.cos(a)/2; graph.nodes[i].y = v + v*Math.sin(a)/2 }").ln();
    }

    @Override
    public void writeDefinition(ElementDetails details) {
        this.out.addChained("attr('r',", details.overallSize, ")").endStatement();
        this.addAestheticsAndTooltips(details, true);
    }
}

