/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.build.d3.diagrams;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.List;
import org.brunel.build.d3.D3Interaction;
import org.brunel.build.d3.diagrams.D3Diagram;
import org.brunel.build.d3.element.ElementDetails;
import org.brunel.build.d3.element.ElementRepresentation;
import org.brunel.build.info.ChartStructure;
import org.brunel.build.util.ScriptWriter;
import org.brunel.data.Data;
import org.brunel.data.Dataset;
import org.brunel.maps.LabelPoint;
import org.brunel.model.VisSingle;

public class GeoMapLabels
extends D3Diagram {
    private final NumberFormat F = new DecimalFormat("#.####");
    private final ChartStructure structure;

    public GeoMapLabels(VisSingle vis, Dataset data, ChartStructure structure, D3Interaction interaction, ScriptWriter out) {
        super(vis, data, interaction, out);
        this.structure = structure;
    }

    @Override
    public String getRowKey() {
        return "d[2]";
    }

    @Override
    public void preBuildDefinitions() {
        List<LabelPoint> pointsMax;
        List<LabelPoint> all = this.structure.geo.getLabelsWithinScaleBounds();
        int maxPoints = 40;
        if (this.vis.tDiagramParameters[0].modifiers().length > 0) {
            maxPoints = (int)this.vis.tDiagramParameters[0].modifiers()[0].asDouble();
        }
        List<LabelPoint> points = (pointsMax = this.subset(all, maxPoints)).size() <= maxPoints ? pointsMax : pointsMax.subList(0, maxPoints);
        int popHigh = 0;
        int popLow = 100;
        for (LabelPoint p : points) {
            popHigh = Math.max(popHigh, p.pop);
            popLow = Math.min(popLow, p.pop);
        }
        this.out.onNewLine().comment("lon, lat, label, size, type");
        this.out.add("var geo_labels = [").indentMore();
        boolean first = true;
        for (LabelPoint p : points) {
            if (!first) {
                this.out.add(", ");
            }
            String s = "[" + this.F.format(p.x) + "," + this.F.format(p.y) + "," + Data.quote((String)p.label) + "," + this.radiusFor(p, popHigh, popLow) + "," + (5 - p.importance) + "]";
            if (this.out.currentColumn() + s.length() > 120) {
                this.out.onNewLine();
            }
            this.out.add(s);
            first = false;
        }
        this.out.indentLess().add("]").endStatement();
    }

    private List<LabelPoint> subset(List<LabelPoint> all, int maxPoints) {
        return maxPoints < all.size() ? all.subList(0, maxPoints) : all;
    }

    @Override
    public ElementDetails initializeDiagram() {
        return ElementDetails.makeForDiagram(this.vis, ElementRepresentation.symbol, "point", "geo_labels");
    }

    @Override
    public void writeDefinition(ElementDetails details) {
        this.out.addChained("attr('d', function(d) { return BrunelD3.symbol(['star','square','circle','circle','circle'][d[4]], d[3]*geom.default_point_size/14)})").addChained("attr('class', function(d) { return 'mark L' + d[4] })");
        this.out.addChained("attr('transform', projectTransform)");
        this.out.endStatement();
        this.out.add("labels.classed('map', true)").endStatement();
        this.out.add("var labeling = {").indentMore().onNewLine().add("method:'right',").onNewLine().add("content: function(d) {return d[2]}").indentLess().onNewLine().add("}").endStatement();
        this.out.add("BrunelD3.time('start labeling')").endStatement();
        this.out.add("BrunelD3.label(selection, labels, labeling, 0)").endStatement();
        this.out.add("BrunelD3.time('end labeling')").endStatement();
    }

    @Override
    public boolean needsDiagramLabels() {
        return false;
    }

    @Override
    public void writeDiagramEnter() {
        this.out.addChained("classed('map', true)");
        this.out.endStatement();
    }

    private int radiusFor(LabelPoint p, int high, int low) {
        return (int)Math.round((double)(p.pop - low) * 4.0 / (double)(high - low) + 3.0);
    }
}

