/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.build.d3.diagrams;

import java.util.ArrayList;
import org.brunel.action.Param;
import org.brunel.build.d3.D3Interaction;
import org.brunel.build.d3.D3LabelBuilder;
import org.brunel.build.d3.diagrams.Bubble;
import org.brunel.build.d3.diagrams.Chord;
import org.brunel.build.d3.diagrams.Cloud;
import org.brunel.build.d3.diagrams.GeoMap;
import org.brunel.build.d3.diagrams.GeoMapLabels;
import org.brunel.build.d3.diagrams.Network;
import org.brunel.build.d3.diagrams.Tree;
import org.brunel.build.d3.diagrams.Treemap;
import org.brunel.build.d3.element.ElementDetails;
import org.brunel.build.info.ElementStructure;
import org.brunel.build.util.ScriptWriter;
import org.brunel.data.Data;
import org.brunel.data.Dataset;
import org.brunel.model.VisSingle;
import org.brunel.model.VisTypes;

public abstract class D3Diagram {
    final ScriptWriter out;
    final Param size;
    final VisTypes.Element element;
    final VisSingle vis;
    final D3LabelBuilder labelBuilder;
    final D3Interaction interaction;
    final String[] position;
    private boolean isHierarchy;

    public static D3Diagram make(ElementStructure structure, D3Interaction interaction, ScriptWriter out) {
        VisSingle vis = structure.vis;
        Dataset data = structure.data;
        if (vis.tDiagram == null) {
            return null;
        }
        if (vis.tDiagram == VisTypes.Diagram.bubble) {
            return new Bubble(vis, data, interaction, out);
        }
        if (vis.tDiagram == VisTypes.Diagram.chord) {
            return new Chord(vis, data, interaction, out);
        }
        if (vis.tDiagram == VisTypes.Diagram.cloud) {
            return new Cloud(vis, data, interaction, out);
        }
        if (vis.tDiagram == VisTypes.Diagram.tree) {
            return new Tree(vis, data, interaction, out);
        }
        if (vis.tDiagram == VisTypes.Diagram.treemap) {
            return new Treemap(vis, data, interaction, out);
        }
        if (vis.tDiagram == VisTypes.Diagram.network) {
            return new Network(vis, data, structure, structure.chart.getEdge(), interaction, out);
        }
        if (vis.tDiagram == VisTypes.Diagram.map) {
            if (vis.tDiagramParameters.length == 1 && vis.tDiagramParameters[0].asString().equals("labels")) {
                return new GeoMapLabels(vis, data, structure.chart, interaction, out);
            }
            return new GeoMap(vis, data, structure.geo, interaction, out);
        }
        throw new IllegalStateException("Unknown diagram: " + (Object)((Object)vis.tDiagram));
    }

    D3Diagram(VisSingle vis, Dataset data, D3Interaction interaction, ScriptWriter out) {
        this.vis = vis;
        this.out = out;
        this.size = vis.fSize.isEmpty() ? null : vis.fSize.get(0);
        this.position = vis.positionFields();
        this.element = vis.tElement;
        this.interaction = interaction;
        this.labelBuilder = new D3LabelBuilder(vis, out, data);
    }

    public String getRowKey() {
        return "d.key";
    }

    public String getStyleClasses() {
        String classes = "diagram " + this.vis.tDiagram.name();
        return "'" + (this.isHierarchy ? classes + " hierarchy" : classes) + "'";
    }

    public boolean needsDiagramExtras() {
        return false;
    }

    public boolean needsDiagramLabels() {
        return false;
    }

    public D3Interaction.ZoomType getZoomType() {
        return this.interaction.getZoomType();
    }

    public void preBuildDefinitions() {
    }

    public void writeBuildCommands() {
    }

    public abstract ElementDetails initializeDiagram();

    public abstract void writeDefinition(ElementDetails var1);

    public void writeDiagramEnter() {
        this.out.endStatement();
    }

    public void writePerChartDefinitions() {
    }

    public void writePreDefinition(ElementDetails details) {
    }

    void addAestheticsAndTooltips(ElementDetails details, boolean addLabels) {
        String remapAesthetics = "if (d == null || d.row == null) return; ";
        if (!this.vis.itemsTooltip.isEmpty()) {
            this.labelBuilder.addTooltips(details);
        }
        if (!this.vis.fColor.isEmpty()) {
            this.out.add("selection.style('fill', function(d) { " + remapAesthetics + "return color(d) })").endStatement();
        }
        if (!this.vis.fOpacity.isEmpty()) {
            this.out.add("selection.style('fill-opacity', function(d) { " + remapAesthetics + "return opacity(d) })").addChained("style('stroke-opacity', function(d) { " + remapAesthetics + "return opacity(d) })").endStatement();
        }
        if (addLabels) {
            this.labelBuilder.addElementLabeling();
        }
    }

    void makeHierarchicalTree() {
        String[] positionFields = this.vis.positionFields();
        String fieldsList = positionFields.length == 0 ? "" : ", " + this.quoted(positionFields);
        String sizeParam = this.size == null ? null : Data.quote((String)this.size.asField());
        this.out.add("var tree = BrunelData.diagram_Hierarchical.makeByNestingFields(processed, " + sizeParam + fieldsList + ")").endStatement();
        this.isHierarchy = true;
    }

    protected String quoted(String ... items) {
        ArrayList<String> p = new ArrayList<String>();
        for (String s : items) {
            p.add(Data.quote((String)s));
        }
        return Data.join(p);
    }
}

