/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.build.d3.diagrams;

import org.brunel.build.d3.D3Interaction;
import org.brunel.build.d3.D3LabelBuilder;
import org.brunel.build.d3.diagrams.D3Diagram;
import org.brunel.build.d3.element.ElementDetails;
import org.brunel.build.d3.element.ElementRepresentation;
import org.brunel.build.util.ScriptWriter;
import org.brunel.data.Dataset;
import org.brunel.model.VisSingle;

class Cloud
extends D3Diagram {
    public Cloud(VisSingle vis, Dataset data, D3Interaction interaction, ScriptWriter out) {
        super(vis, data, interaction, out);
    }

    @Override
    public ElementDetails initializeDiagram() {
        this.out.comment("Build the cloud layout");
        this.out.add("var cloud = BrunelD3.cloudLayout(processed, [geom.inner_width, geom.inner_height])").endStatement();
        this.out.add("function keyFunction(d) { return d.key }").endStatement();
        return ElementDetails.makeForDiagram(this.vis, ElementRepresentation.text, "text", "data._rows");
    }

    @Override
    public void writeDefinition(ElementDetails details) {
        this.out.addChained("each(cloud.prepare).call(cloud.build)").endStatement();
        this.addAestheticsAndTooltips(details, false);
    }

    @Override
    public void writeDiagramEnter() {
        this.out.addChained("style('text-anchor', 'middle').classed('label', true)").addChained("text(labeling.content)");
        D3LabelBuilder.addFontSizeAttribute(this.vis, this.out);
        this.out.endStatement();
    }
}

