/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.build.d3;

import org.brunel.action.Param;
import org.brunel.build.info.ChartStructure;
import org.brunel.build.util.ModelUtil;
import org.brunel.build.util.ScriptWriter;
import org.brunel.data.Data;
import org.brunel.data.Dataset;
import org.brunel.data.Field;
import org.brunel.model.VisSingle;

public class D3TitleBuilder {
    private final String location;
    private String content;
    private String alignment;
    private int fontSize;

    public D3TitleBuilder(ChartStructure structure, String location) {
        this.location = location;
        this.build(structure);
    }

    public double verticalSpace() {
        return this.content == null ? 0.0 : (double)this.fontSize * 1.5;
    }

    public void writeContent(ScriptWriter out) {
        if (this.content == null) {
            return;
        }
        String xLoc = "50%";
        String anchor = "middle";
        if (this.alignment.equals("left")) {
            xLoc = "0%";
            anchor = "start";
        }
        if (this.alignment.equals("right")) {
            xLoc = "100%";
            anchor = "end";
        }
        out.add("chart.append('text').attr('class', 'title " + this.location + "')").add(".text(" + this.content + ").style('text-anchor', '" + anchor + "').attr('dy','0.8em')").addChained("attr('x','" + xLoc + "')");
        if (this.location.equals("footer")) {
            out.addChained("attr('y','100%').attr('dy', '-0.4em')");
        } else {
            out.addChained("attr('y',0)");
        }
        out.endStatement();
    }

    private void build(ChartStructure structure) {
        for (VisSingle vis : structure.elements) {
            if (vis.itemsTitle.isEmpty()) continue;
            String result = this.makeText(vis, vis.getDataset());
            this.content = result.isEmpty() ? null : Data.quote((String)result);
            this.alignment = ModelUtil.getTitlePosition(vis, this.location);
            ModelUtil.Size size = ModelUtil.getTitleSize(vis, this.location);
            this.fontSize = size == null ? 16 : (int)Math.round(size.valueInPixels(16.0));
        }
    }

    private String makeText(VisSingle vis, Dataset data) {
        StringBuilder s = new StringBuilder();
        for (Param p : vis.itemsTitle) {
            String pType = "header";
            if (p.hasModifiers()) {
                pType = p.modifiers()[0].asString();
            }
            if (!pType.equals(this.location)) continue;
            if (p.isField()) {
                Field f = data.field(p.asField(data));
                if (f == null) {
                    throw new IllegalStateException("Unknown field: " + p.asString());
                }
                s.append(f.label);
                continue;
            }
            s.append(p.asString());
        }
        return s.toString();
    }
}

