/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.build.d3;

import java.util.List;
import org.brunel.action.Param;
import org.brunel.build.d3.D3DataBuilder;
import org.brunel.build.d3.D3ScaleBuilder;
import org.brunel.build.info.ChartStructure;
import org.brunel.build.info.ElementStructure;
import org.brunel.build.util.ScriptWriter;
import org.brunel.model.VisSingle;
import org.brunel.model.VisTypes;

public class D3Interaction {
    private final ChartStructure structure;
    private final D3ScaleBuilder scales;
    private final ScriptWriter out;
    private final ZoomType zoomable;

    public D3Interaction(ChartStructure structure, D3ScaleBuilder scales, ScriptWriter out) {
        this.structure = structure;
        this.scales = scales;
        this.out = out;
        this.zoomable = this.isZoomable(structure.elementStructure) ? (structure.geo == null ? ZoomType.CoordinateZoom : ZoomType.MapZoom) : ZoomType.None;
    }

    public ZoomType getZoomType() {
        return this.zoomable;
    }

    private boolean isZoomable(ElementStructure[] elements) {
        if (this.structure.coordinates.xCategorical && this.structure.coordinates.yCategorical) {
            return false;
        }
        if (this.structure.diagram != null && this.structure.geo == null || this.scales.coords == VisTypes.Coordinates.polar) {
            return false;
        }
        boolean defaultResult = true;
        for (ElementStructure e : elements) {
            if (e.vis.tInteraction.containsKey((Object)VisTypes.Interaction.panzoom)) {
                return true;
            }
            if (!e.vis.tInteraction.containsKey((Object)VisTypes.Interaction.none)) continue;
            defaultResult = false;
        }
        return defaultResult;
    }

    public void addElementHandlers(VisSingle vis, D3DataBuilder dataBuilder) {
        Param p = vis.tInteraction.get((Object)VisTypes.Interaction.select);
        if (p != null) {
            this.out.add("selection.on('" + this.eventName(p) + "', function(d) { BrunelD3.select(d.row, processed, original, this, updateAll) } )").endStatement();
        }
        if ((p = vis.tInteraction.get((Object)VisTypes.Interaction.call)) != null) {
            this.out.add("selection.on('" + this.eventName(p) + "', " + this.functionName(p, dataBuilder) + " )").endStatement();
        }
    }

    private String eventName(Param p) {
        Param param = p.firstModifier();
        return param == null ? "click" : param.asString();
    }

    private String functionName(Param p, D3DataBuilder dataBuilder) {
        if (p.modifiers().length > 1) {
            return p.modifiers()[1].asString();
        }
        String base = "BrunelD3.showSelect";
        List<String> list = dataBuilder.makeKeyFields();
        if (list.size() == 1 && list.get(0).equals("#row")) {
            return "function(d) { " + base + ".call(this, d.row, data._key(d.row).toString(), processed, element) }";
        }
        if (list.size() == 1) {
            return "function(d) { " + base + ".call(this, d.row, data._key(d.row), processed, element) }";
        }
        return "function(d) { " + base + ".call(this, d.row, data._key(d.row).split('|'), processed, element) }";
    }

    public void addPrerequisites() {
        if (this.zoomable == ZoomType.CoordinateZoom) {
            this.out.add("var overlay = interior.append('g').attr('class', 'element')").addChained("attr('class', 'overlay').style('cursor','move').style('fill','none').style('pointer-events','all')").endStatement();
            this.out.add("var zoom = d3.behavior.zoom().on('zoom', function() {build(-1)} )").endStatement();
            this.out.add("overlay.append('rect').attr('class', 'overlay')").addChained("attr('width', geom.inner_width)").addChained("attr('height', geom.inner_height)").addChained("call(zoom)").endStatement();
        }
    }

    public void addScaleInteractivity() {
        if (this.zoomable == ZoomType.None) {
            return;
        }
        this.out.add("zoom");
        if (this.scales.coords == VisTypes.Coordinates.transposed) {
            if (!this.structure.coordinates.xCategorical) {
                this.out.add(".y(scale_x)");
            }
            if (!this.structure.coordinates.yCategorical) {
                this.out.add(".x(scale_y)");
            }
        } else {
            if (!this.structure.coordinates.xCategorical) {
                this.out.add(".x(scale_x)");
            }
            if (!this.structure.coordinates.yCategorical) {
                this.out.add(".y(scale_y)");
            }
        }
        this.out.endStatement();
    }

    public static enum ZoomType {
        MapZoom,
        CoordinateZoom,
        None;

    }
}

