/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.build.controls;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.List;
import org.brunel.action.Param;
import org.brunel.data.Dataset;
import org.brunel.data.Field;

public class FilterControl {
    public final String data;
    public final String id;
    public final String label;
    public final Object[] categories;
    public final Double min;
    public final Double max;
    public final Double lowValue;
    public final Double highValue;
    public final Object[] selectedCategories;

    public static FilterControl makeForField(Dataset data, String fieldID, Param modifier) {
        Field field = data.field(fieldID);
        if (field.preferCategorical()) {
            Object[] selectedCategories = null;
            if (modifier != null) {
                if (modifier.type() == Param.Type.option) {
                    selectedCategories = new String[]{modifier.asString()};
                } else if (modifier.type() == Param.Type.list) {
                    List<Param> params = modifier.asList();
                    selectedCategories = new String[params.size()];
                    for (int i = 0; i < selectedCategories.length; ++i) {
                        selectedCategories[i] = params.get(i).asString();
                    }
                }
            }
            return new FilterControl(data.name(), fieldID, field.label, field.categories(), null, null, null, null, selectedCategories);
        }
        Double low = null;
        Double high = null;
        if (modifier != null) {
            List<Param> params;
            if (modifier.type() == Param.Type.number) {
                low = modifier.asDouble();
            } else if (modifier.type() == Param.Type.list && (params = modifier.asList()).size() == 2) {
                low = params.get(0).asDouble();
                high = params.get(1).asDouble();
            }
        }
        return new FilterControl(data.name(), fieldID, field.label, null, field.min(), field.max(), low, high, null);
    }

    public static JsonObject buildFilterDefaults(List<FilterControl> filterControls) {
        JsonObject jobj = new JsonObject();
        for (FilterControl f : filterControls) {
            JsonObject aFilter;
            if (f.selectedCategories != null) {
                aFilter = new JsonObject();
                aFilter.addProperty("filter_type", "category");
                JsonArray jarray = new JsonArray();
                for (Object o : f.selectedCategories) {
                    jarray.add((JsonElement)new JsonPrimitive(o.toString()));
                }
                aFilter.add("filter", (JsonElement)jarray);
                jobj.add(f.id, (JsonElement)aFilter);
                continue;
            }
            if (f.lowValue == null) continue;
            aFilter = new JsonObject();
            aFilter.addProperty("filter_type", "range");
            JsonObject range = new JsonObject();
            range.addProperty("min", (Number)f.lowValue);
            Double high = f.highValue == null ? f.max : f.highValue;
            range.addProperty("max", (Number)high);
            aFilter.add("filter", (JsonElement)range);
            jobj.add(f.id, (JsonElement)aFilter);
        }
        return jobj;
    }

    private FilterControl(String data, String id, String label, Object[] categories, Double min, Double max, Double lowValue, Double highValue, Object[] selectedCategories) {
        this.data = data;
        this.id = id;
        this.label = label;
        this.categories = categories;
        this.min = min;
        this.max = max;
        this.lowValue = lowValue == null ? null : Double.valueOf(Math.max(min, lowValue));
        this.highValue = highValue == null ? null : Double.valueOf(Math.min(max, highValue));
        this.selectedCategories = selectedCategories;
        if (lowValue != null && highValue != null && lowValue > highValue) {
            throw new IllegalArgumentException("Low filter value (" + lowValue + ") cannot be greater than high filter value (" + highValue + ") for: " + label);
        }
        this.substituteExactCase();
    }

    private void substituteExactCase() {
        if (this.selectedCategories != null) {
            for (int i = 0; i < this.selectedCategories.length; ++i) {
                for (int j = 0; j < this.categories.length; ++j) {
                    String main;
                    String selected;
                    if (!(this.selectedCategories[i] instanceof String) || !(this.categories[j] instanceof String) || !(selected = (String)this.selectedCategories[i]).equalsIgnoreCase(main = (String)this.categories[j])) continue;
                    this.selectedCategories[i] = main;
                }
            }
        }
    }
}

