/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.action;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.brunel.action.ActionSimplification;
import org.brunel.action.ActionStep;
import org.brunel.action.Parser;
import org.brunel.data.Dataset;
import org.brunel.model.VisComposition;
import org.brunel.model.VisItem;
import org.brunel.model.VisSingle;

public class Action
implements Comparable<Action> {
    public final ActionStep[] steps;

    public static Action parse(String text) {
        return Parser.parse(text);
    }

    Action(ActionStep ... actions) {
        this.steps = actions;
    }

    public Action append(Action action) {
        if (action == null) {
            return this;
        }
        ActionStep[] others = action.steps;
        ActionStep[] combined = new ActionStep[this.steps.length + others.length];
        System.arraycopy(this.steps, 0, combined, 0, this.steps.length);
        System.arraycopy(others, 0, combined, this.steps.length, others.length);
        return new Action(combined);
    }

    public VisItem apply() {
        return this.apply(null);
    }

    public VisItem apply(Dataset data) {
        List<ActionStep> all = Arrays.asList(this.steps);
        List<List<ActionStep>> splits = this.split(all, "|");
        if (splits == null) {
            return this.applyChartElements(all, data);
        }
        VisItem[] charts = new VisItem[splits.size()];
        for (int i = 0; i < charts.length; ++i) {
            charts[i] = this.applyChartElements(splits.get(i), data);
            data = charts[i].getDataSets()[0];
        }
        return VisComposition.tile(charts);
    }

    @Override
    public int compareTo(Action o) {
        if (this == o) {
            return 0;
        }
        if (this.steps.length != o.steps.length) {
            return this.steps.length - o.steps.length;
        }
        for (int i = 0; i < this.steps.length; ++i) {
            ActionStep a = this.steps[i];
            ActionStep b = o.steps[i];
            int c = a.name.compareTo(b.name);
            if (c != 0) {
                return c;
            }
            if (a.parameters.length != b.parameters.length) {
                return a.parameters.length - b.parameters.length;
            }
            for (int j = 0; j < a.parameters.length; ++j) {
                c = a.parameters[j].compareTo(b.parameters[j]);
                if (c == 0) continue;
                return c;
            }
        }
        return 0;
    }

    public int hashCode() {
        return 31 + Arrays.hashCode(this.steps);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof Action)) {
            return false;
        }
        return Arrays.equals(this.steps, ((Action)other).steps);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        for (ActionStep a : this.steps) {
            if (b.length() > 0) {
                b.append(" ");
            }
            b.append(a);
        }
        return b.toString();
    }

    public Action simplify() {
        if (this.steps.length == 1) {
            return this;
        }
        ActionStep[] sequence = new ActionSimplification(this.steps).make();
        if (sequence.length == 0) {
            return null;
        }
        return new Action(sequence);
    }

    private VisItem applyChartElements(List<ActionStep> steps, Dataset data) {
        List<List<ActionStep>> splits = this.split(steps, "+");
        if (splits == null) {
            return this.applyNesting(steps, data);
        }
        VisItem[] elements = new VisItem[splits.size()];
        for (int i = 0; i < elements.length; ++i) {
            elements[i] = this.applyNesting(splits.get(i), data);
            data = elements[i].getDataSets()[0];
        }
        return VisComposition.overlay(elements);
    }

    private VisItem applyNesting(List<ActionStep> steps, Dataset data) {
        VisSingle outer = new VisSingle(data);
        for (int i = 0; i < steps.size(); ++i) {
            ActionStep a = steps.get(i);
            if (a.name.startsWith(">")) {
                VisItem inner = this.applyNesting(steps.subList(i + 1, steps.size()), data);
                return a.name.equals(">") ? VisComposition.inside(outer, inner) : VisComposition.nested(outer, inner);
            }
            outer = a.apply(outer);
        }
        return outer;
    }

    private List<List<ActionStep>> split(List<ActionStep> steps, String splitActionName) {
        ArrayList<List<ActionStep>> splits = new ArrayList<List<ActionStep>>();
        ArrayList<ActionStep> current = new ArrayList<ActionStep>();
        for (ActionStep a : steps) {
            if (a.name.equals(splitActionName)) {
                if (current.isEmpty()) {
                    throw new IllegalStateException("Error processing '" + splitActionName + "'. Composition must join standard actions");
                }
                splits.add(current);
                current = new ArrayList();
                continue;
            }
            current.add(a);
        }
        if (splits.isEmpty()) {
            return null;
        }
        if (current.isEmpty()) {
            throw new IllegalStateException("Error processing '" + splitActionName + "'. Composition must join standard actions");
        }
        splits.add(current);
        return splits;
    }
}

