#!/usr/bin/env python


'''
$Id: tester4.py 983 2012-06-28 21:34:54Z jemian $

develop regular expression to match macro declarations
'''


import re
import os

# TODO: consider multiline declaration signtures
# This test module only considers single line declarations

spec_macro_declaration_match_re = re.compile(
                              r'^'                      # line start
                            + r'\s*?'                   # optional blank space
                            + r'(r?def)'                # 0: def_type (rdef | def)
                            + r'\s*?'                   # optional blank space
                            + r'([a-zA-Z_][\w_]*)'      # 1: macro_name
                            + r'(.*?)'                  # 2: optional arguments
                            + r'(#.*?)?'                # 3: optional comment
                            + r'$'                      # line end
                        )

spec_cdef_declaration_match_re = re.compile(
                              r'^'                      # line start
                            + r'.*?'                    # optional any kind of preceding stuff, was \s*? (optional blank space)
                            + r'(cdef)'                 # 0: cdef
                            + r'\('                     # opening parenthesis
                            + r'(.*?)'                  # 1: args (anything between the parentheses)
                            + r'\)'                     # closing parenthesis
                            + r'.*?'                    # optional any kind of stuff
                            + r'(#.*?)?'                # 2: optional comment with content
                            + r'$'                      # line end
                        )

spec_function_declaration_match_re = re.compile(
                              r'^'                      # line start
                            + r'\s*?'                   # optional blank space
                            + r'(r?def)'                # 0: def_type (rdef | def)
                            + r'\s*?'                   # optional blank space
                            + r'([a-zA-Z_][\w_]*)'      # 1: function_name
                            + r'\('                     # opening parenthesis
                            + r'(.*?)'                  # 2: args (anything between the parentheses)
                            + r'\)'                     # closing parenthesis
                            + r'\s*?'                   # optional blank space
                            + r'\''                     # open macro content
                            + r'(.*?)'                  # 3: args (anything between the parentheses)
                            + r'(#.*?)?'                # 4: optional comment
                            + r'$'                      # line end
                        )

TEST_DIR = os.path.join('..', 'macros')

tests = {
    'macro':    spec_macro_declaration_match_re,
    'cdef':     spec_cdef_declaration_match_re,
    'function': spec_function_declaration_match_re,
}

for name, test in tests.items():
    print "%10s  %s" % (name, test.pattern)

for f in sorted(os.listdir(TEST_DIR)):
    if f.endswith('.mac'):
        print '\n', f
        for linenumber, line in enumerate(open(os.path.join(TEST_DIR, f)).readlines()):
            for name in ('cdef', 'function', 'macro'):
                m = tests[name].match(line)
                if m is not None:
                    print name, linenumber+1, m.groups()
                    break
