#!/usr/bin/env python
# -*- coding: utf-8 -*-
# @Author: lijim001 rocky
# @Date:   2015-05-26 16:25:35
# @Last Modified time: 2015-05-26 16:26:23

import hashlib
import datetime
import urllib

class ChinaBank(object):
    GATE_WAY_URL='https://pay3.chinabank.com.cn/PayGate'

    def __init__(self,mid,key,oid,amount,redirect_url,notify_url,moneytype='CNY'):
        self.mid=mid#商户编号
        self.key=key #商户md5秘钥
        self._oid=oid #oid:业务系统订单编号，最好不超过30位。12323244。。
        self.amount=amount
        self.moneytype=moneytype
        self.redirect_url=redirect_url #支付成功跳转页面
        self.notify_url=self._generate_notify_url(notify_url)
        self.oid=self._generate_oid()

    def _generate_notify_url(self,url):
        return '[url:=%s]'%url

    def _generate_oid(self,):

        day=datetime.datetime.now().strftime("%Y%m%d")

        return "-".join([day,self.mid,self._oid])

    def _generate_vmd5(self):
        try:
            raw_s=("%s"*6)%(self.amount,self.moneytype,self.oid,self.mid,self.redirect_url,self.key)
        except TypeError:
            raise Exception("args not enough.")

        o=hashlib.md5()
        o.update(raw_s)
        return o.hexdigest().upper()


    def create_pay_url(self,**kwargs):
        dt={}

        dt["v_mid"]=self.mid
        dt["v_oid"]=self.oid
        dt["v_amount"]=self.amount
        dt["v_moneytype"]=self.moneytype
        dt["v_url"]=self.redirect_url
        dt["v_md5info"]=self._generate_vmd5()
        dt["v_amount"]=self.amount
        dt["remark2"]=self.notify_url
        dt.update(kwargs)

        return self.GATE_WAY_URL+"?"+urllib.urlencode(dt)
