/*
 * Decompiled with CFR 0.152.
 */
package py4j;

import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.SocketFactory;
import py4j.CallbackConnection;
import py4j.Py4JClientConnection;
import py4j.Py4JException;
import py4j.Py4JNetworkException;
import py4j.Py4JPythonClient;

public class CallbackClient
implements Py4JPythonClient {
    public static final String DEFAULT_ADDRESS = "127.0.0.1";
    protected final int port;
    protected final InetAddress address;
    protected final SocketFactory socketFactory;
    protected final Deque<Py4JClientConnection> connections = new ArrayDeque<Py4JClientConnection>();
    private final Lock lock = new ReentrantLock(true);
    private final Logger logger = Logger.getLogger(CallbackClient.class.getName());
    private boolean isShutdown = false;
    public static final long DEFAULT_MIN_CONNECTION_TIME = 30L;
    private final ScheduledExecutorService executor = Executors.newScheduledThreadPool(1);
    protected final long minConnectionTime;
    protected final TimeUnit minConnectionTimeUnit;

    public CallbackClient(int port) {
        this.port = port;
        try {
            this.address = InetAddress.getByName(DEFAULT_ADDRESS);
        }
        catch (Exception e) {
            throw new Py4JNetworkException("Default address could not be determined when creating communication channel.");
        }
        this.minConnectionTime = 30L;
        this.minConnectionTimeUnit = TimeUnit.SECONDS;
        this.socketFactory = SocketFactory.getDefault();
        this.setupCleaner();
    }

    public CallbackClient(int port, InetAddress address) {
        this(port, address, 30L, TimeUnit.SECONDS);
    }

    public CallbackClient(int port, InetAddress address, long minConnectionTime, TimeUnit minConnectionTimeUnit) {
        this(port, address, minConnectionTime, minConnectionTimeUnit, SocketFactory.getDefault());
    }

    public CallbackClient(int port, InetAddress address, long minConnectionTime, TimeUnit minConnectionTimeUnit, SocketFactory socketFactory) {
        this.port = port;
        this.address = address;
        this.minConnectionTime = minConnectionTime;
        this.minConnectionTimeUnit = minConnectionTimeUnit;
        this.socketFactory = socketFactory;
        this.setupCleaner();
    }

    @Override
    public InetAddress getAddress() {
        return this.address;
    }

    protected Py4JClientConnection getConnection() throws IOException {
        Py4JClientConnection connection = null;
        connection = this.connections.pollLast();
        if (connection == null) {
            connection = new CallbackConnection(this.port, this.address, this.socketFactory);
            connection.start();
        }
        return connection;
    }

    protected Py4JClientConnection getConnectionLock() {
        Py4JClientConnection cc = null;
        try {
            this.logger.log(Level.INFO, "Getting CB Connection");
            this.lock.lock();
            if (!this.isShutdown) {
                cc = this.getConnection();
                this.logger.log(Level.INFO, "Acquired CB Connection");
            } else {
                this.logger.log(Level.INFO, "Shuting down, no connection can be created.");
            }
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Critical error while sending a command", e);
            throw new Py4JException("Error while obtaining a new communication channel", e);
        }
        finally {
            this.lock.unlock();
        }
        return cc;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public Py4JPythonClient copyWith(InetAddress pythonAddress, int pythonPort) {
        return new CallbackClient(pythonPort, pythonAddress, this.minConnectionTime, this.minConnectionTimeUnit, this.socketFactory);
    }

    protected void giveBackConnection(Py4JClientConnection cc) {
        try {
            this.lock.lock();
            if (cc != null) {
                if (!this.isShutdown) {
                    this.connections.addLast(cc);
                } else {
                    cc.shutdown();
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void periodicCleanup() {
        try {
            this.lock.lock();
            if (!this.isShutdown) {
                int size = this.connections.size();
                for (int i = 0; i < size; ++i) {
                    Py4JClientConnection cc = this.connections.pollLast();
                    if (cc.wasUsed()) {
                        cc.setUsed(false);
                        this.connections.addFirst(cc);
                        continue;
                    }
                    cc.shutdown();
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public String sendCommand(String command) {
        return this.sendCommand(command, true);
    }

    @Override
    public String sendCommand(String command, boolean blocking) {
        String returnCommand = null;
        Py4JClientConnection cc = this.getConnectionLock();
        if (cc == null) {
            throw new Py4JException("Cannot obtain a new communication channel");
        }
        try {
            returnCommand = cc.sendCommand(command, blocking);
            this.giveBackConnection(cc);
        }
        catch (Py4JNetworkException pe) {
            this.logger.log(Level.WARNING, "Error while sending a command", pe);
            cc.shutdown();
            if (this.shouldRetrySendCommand(cc, pe)) {
                returnCommand = this.sendCommand(command, blocking);
            }
            throw new Py4JException("Error while sending a command.", pe);
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Critical error while sending a command", e);
            throw new Py4JException("Error while sending a command.");
        }
        return returnCommand;
    }

    protected boolean shouldRetrySendCommand(Py4JClientConnection cc, Py4JException pe) {
        return true;
    }

    protected void setupCleaner() {
        this.executor.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                CallbackClient.this.periodicCleanup();
            }
        }, this.minConnectionTime, this.minConnectionTime, this.minConnectionTimeUnit);
    }

    @Override
    public void shutdown() {
        this.logger.info("Shutting down Callback Client");
        try {
            this.lock.lock();
            this.isShutdown = true;
            for (Py4JClientConnection cc : this.connections) {
                cc.shutdown();
            }
            this.executor.shutdownNow();
            this.connections.clear();
        }
        finally {
            this.lock.unlock();
        }
    }
}

