/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.proactive.utils;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Locale;
import org.objectweb.proactive.utils.LinePosition;

public class PrefixPrintWriter
extends PrintWriter {
    private final String prefix;
    private final LinePosition linePosition = new LinePosition();
    String lineSeparator = System.getProperty("line.separator");

    public PrefixPrintWriter(Writer out, String prefix) {
        super(out);
        this.prefix = prefix;
    }

    public PrefixPrintWriter(Writer out, String prefix, boolean autoFlush) {
        super(out, autoFlush);
        this.prefix = prefix;
    }

    public PrefixPrintWriter(OutputStream out, String prefix) {
        super(out);
        this.prefix = prefix;
    }

    public PrefixPrintWriter(OutputStream out, String prefix, boolean autoFlush) {
        super(out, autoFlush);
        this.prefix = prefix;
    }

    public PrefixPrintWriter(String fileName, String prefix) throws FileNotFoundException {
        super(fileName);
        this.prefix = prefix;
    }

    public PrefixPrintWriter(String fileName, String prefix, String csn) throws FileNotFoundException, UnsupportedEncodingException {
        super(fileName, csn);
        this.prefix = prefix;
    }

    public PrefixPrintWriter(File file, String prefix) throws FileNotFoundException {
        super(file);
        this.prefix = prefix;
    }

    public PrefixPrintWriter(File file, String prefix, String csn) throws FileNotFoundException, UnsupportedEncodingException {
        super(file, csn);
        this.prefix = prefix;
    }

    @Override
    public void println() {
        super.println();
        this.linePosition.reset();
    }

    @Override
    public void println(boolean x) {
        super.println(x);
        this.linePosition.reset();
    }

    @Override
    public void println(char x) {
        super.println(x);
        this.linePosition.reset();
    }

    @Override
    public void println(int x) {
        super.println(x);
        this.linePosition.reset();
    }

    @Override
    public void println(long x) {
        super.println(x);
        this.linePosition.reset();
    }

    @Override
    public void println(float x) {
        super.println(x);
        this.linePosition.reset();
    }

    @Override
    public void println(double x) {
        super.println(x);
        this.linePosition.reset();
    }

    @Override
    public void println(char[] x) {
        super.println(x);
        this.linePosition.reset();
    }

    @Override
    public void println(String x) {
        super.println(x);
        this.linePosition.reset();
    }

    @Override
    public void println(Object x) {
        super.println(x);
        this.linePosition.reset();
    }

    @Override
    public void write(int c) {
        this.maybePrintPrefix();
        super.write(c);
    }

    @Override
    public void write(char[] buf, int off, int len) {
        this.maybePrintPrefix();
        super.write(buf, off, len);
    }

    @Override
    public void write(char[] buf) {
        this.maybePrintPrefix();
        super.write(buf);
    }

    @Override
    public void write(String s, int off, int len) {
        this.maybePrintPrefix();
        super.write(s, off, len);
    }

    @Override
    public void write(String s) {
        this.maybePrintPrefix();
        super.write(s);
        if (s.contains(this.lineSeparator)) {
            this.linePosition.reset();
        }
    }

    @Override
    public PrintWriter printf(String format, Object ... args) {
        throw new UnsupportedOperationException();
    }

    @Override
    public PrintWriter printf(Locale l, String format, Object ... args) {
        throw new UnsupportedOperationException();
    }

    @Override
    public PrintWriter format(String format, Object ... args) {
        throw new UnsupportedOperationException();
    }

    @Override
    public PrintWriter format(Locale l, String format, Object ... args) {
        throw new UnsupportedOperationException();
    }

    private void ensureOpen() throws IOException {
        if (this.out == null) {
            throw new IOException("Stream closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybePrintPrefix() {
        if (this.linePosition.atStart()) {
            try {
                Object object = this.lock;
                synchronized (object) {
                    this.ensureOpen();
                    this.out.write(this.prefix, 0, this.prefix.length());
                }
            }
            catch (InterruptedIOException x) {
                Thread.currentThread().interrupt();
            }
            catch (IOException e) {
                this.setError();
            }
            this.linePosition.update();
        }
    }
}

