/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scheduler.common.task;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import org.objectweb.proactive.annotation.PublicAPI;
import org.ow2.proactive.scheduler.common.exception.ExecutableCreationException;
import org.ow2.proactive.scripting.InvalidScriptException;
import org.ow2.proactive.scripting.Script;
import org.ow2.proactive.scripting.SimpleScript;

@PublicAPI
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ForkEnvironment
implements Serializable {
    private String javaHome;
    private String workingDir;
    private Map<String, String> systemEnvironment;
    private List<String> jvmArguments;
    private List<String> additionalClasspath;
    private Script<?> script;
    private static final long serialVersionUID = 101L;

    public ForkEnvironment() {
        this.additionalClasspath = new ArrayList<String>();
        this.jvmArguments = new ArrayList<String>();
        this.systemEnvironment = new HashMap<String, String>();
    }

    public ForkEnvironment(ForkEnvironment forkEnvironment) throws ExecutableCreationException {
        this();
        if (forkEnvironment.javaHome != null) {
            this.javaHome = forkEnvironment.javaHome;
        }
        if (forkEnvironment.workingDir != null) {
            this.workingDir = forkEnvironment.workingDir;
        }
        if (forkEnvironment.systemEnvironment != null) {
            this.systemEnvironment.putAll(forkEnvironment.systemEnvironment);
        }
        if (forkEnvironment.jvmArguments != null) {
            for (String entry : forkEnvironment.jvmArguments) {
                this.addJVMArgument(entry);
            }
        }
        if (forkEnvironment.additionalClasspath != null) {
            for (String entry : forkEnvironment.additionalClasspath) {
                this.addAdditionalClasspath(entry);
            }
        }
        if (forkEnvironment.script != null) {
            try {
                this.script = new SimpleScript(forkEnvironment.script);
            }
            catch (InvalidScriptException e) {
                throw new ExecutableCreationException("Failed to copy ForkEnvironment script", e);
            }
        }
    }

    public ForkEnvironment(String workingDir) {
        this.workingDir = workingDir;
    }

    public String getJavaHome() {
        return this.javaHome;
    }

    public void setJavaHome(String javaHome) {
        this.javaHome = javaHome;
    }

    public String getWorkingDir() {
        return this.workingDir;
    }

    public void setWorkingDir(String workingDir) {
        this.workingDir = workingDir;
    }

    public Map<String, String> getSystemEnvironment() {
        if (this.systemEnvironment == null) {
            return new HashMap<String, String>(0);
        }
        return new HashMap<String, String>(this.systemEnvironment);
    }

    public String getSystemEnvironmentVariable(String name) {
        if (this.systemEnvironment == null) {
            return null;
        }
        return this.systemEnvironment.get(name);
    }

    public String addSystemEnvironmentVariable(String name, String value) {
        if (name == null) {
            throw new IllegalArgumentException("Name cannot be null");
        }
        return this.systemEnvironment.put(name, value);
    }

    public List<String> getJVMArguments() {
        if (this.jvmArguments == null) {
            return new ArrayList<String>(0);
        }
        return new ArrayList<String>(this.jvmArguments);
    }

    public void addJVMArgument(String value) {
        Preconditions.checkNotNull((Object)value);
        this.jvmArguments.add(value);
    }

    public List<String> getAdditionalClasspath() {
        if (this.additionalClasspath == null) {
            return new ArrayList<String>(0);
        }
        return new ArrayList<String>(this.additionalClasspath);
    }

    public void addAdditionalClasspath(String ... values) {
        for (String value : values) {
            this.addAdditionalClasspath(value);
        }
    }

    public void addAdditionalClasspath(String value) {
        Preconditions.checkNotNull((Object)value);
        this.additionalClasspath.add(value);
    }

    public Script<?> getEnvScript() {
        return this.script;
    }

    public void setEnvScript(Script<?> script) {
        this.script = script;
    }

    public String toString() {
        String nl = System.lineSeparator();
        return "ForkEnvironment {" + nl + "\tjavaHome = '" + this.javaHome + '\'' + nl + "\tworkingDir = '" + this.workingDir + '\'' + nl + "\tsystemEnvironment = " + this.systemEnvironment + nl + "\tjvmArguments = " + this.jvmArguments + nl + "\tadditionalClasspath = " + this.additionalClasspath + nl + "\tscript = " + (this.script != null ? this.script.display() : null) + nl + '}';
    }
}

