/*
 * Decompiled with CFR 0.152.
 */
package org.araqne.logdb.client.http.impl;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.araqne.codec.Base64;
import org.araqne.codec.EncodingRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamingResultDecoder {
    private final Logger slog = LoggerFactory.getLogger(StreamingResultDecoder.class);
    private ThreadPoolExecutor executor;

    public StreamingResultDecoder(String name, int poolSize) {
        this.executor = new ThreadPoolExecutor(poolSize, poolSize, 10L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(poolSize), new NamedThreadFactory(name), new ThreadPoolExecutor.CallerRunsPolicy());
    }

    public List<Object> decode(List<Map<String, Object>> chunks) throws ExecutionException {
        ArrayList<Future> futures = new ArrayList<Future>();
        for (Map<String, Object> chunk : chunks) {
            Future f = this.executor.submit(new Decoder(chunk));
            futures.add(f);
        }
        ArrayList<Object> result = new ArrayList<Object>();
        for (Future f : futures) {
            do {
                try {
                    result.addAll((Collection)f.get());
                }
                catch (InterruptedException e) {
                }
                catch (ExecutionException e) {
                    throw e;
                }
            } while (!f.isDone());
        }
        return result;
    }

    public void close() {
        this.executor.shutdown();
    }

    public abstract class FunctorBase<T>
    implements Callable<T> {
        private final Logger logger;

        public FunctorBase(Logger logger) {
            this.logger = logger;
        }

        @Override
        public final T call() {
            try {
                return this.callSafely();
            }
            catch (Throwable t) {
                if (this.logger != null) {
                    this.logger.error("unexpected error while running Task", t);
                } else {
                    System.err.println("unexpected error while running Task");
                    t.printStackTrace(System.err);
                }
                throw new IllegalStateException(t);
            }
        }

        protected abstract T callSafely() throws Exception;
    }

    public static class NamedThreadFactory
    implements ThreadFactory {
        private final String prefix;

        public NamedThreadFactory(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, this.prefix);
        }
    }

    private class Decoder
    extends FunctorBase<List<Object>> {
        private Map<String, Object> chunk;

        public Decoder(Map<String, Object> chunk) {
            super(StreamingResultDecoder.this.slog);
            this.chunk = chunk;
        }

        @Override
        protected List<Object> callSafely() throws Exception {
            int originalSize = (Integer)this.chunk.get("size");
            byte[] buf = Base64.decode((String)this.chunk.get("bin"));
            byte[] output = new byte[originalSize];
            Inflater inflater = new Inflater();
            inflater.setInput(buf, 0, buf.length);
            try {
                inflater.inflate(output);
                inflater.reset();
            }
            catch (DataFormatException e) {
                throw new IllegalStateException(e);
            }
            finally {
                inflater.end();
            }
            Map m = (Map)EncodingRule.decode(ByteBuffer.wrap(output));
            if (m.isEmpty()) {
                return Arrays.asList(new Object[0]);
            }
            Object[] rows = null;
            for (String key : m.keySet()) {
                Object[] o = (Object[])m.get(key);
                if (rows == null) {
                    rows = new Object[o.length];
                }
                int i = 0;
                for (Object item : o) {
                    HashMap<String, Object> row = (HashMap<String, Object>)rows[i];
                    if (row == null) {
                        rows[i] = row = new HashMap<String, Object>();
                    }
                    if (item != null) {
                        row.put(key, item);
                    }
                    ++i;
                }
            }
            return Arrays.asList(rows);
        }
    }
}

