/*
 * Decompiled with CFR 0.152.
 */
package org.araqne.logdb.client;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.araqne.logdb.client.FieldInfo;
import org.araqne.logdb.client.StorageEngineConfig;
import org.araqne.logdb.client.TableConfig;

public class TableSchemaInfo {
    private String name;
    private int id;
    private StorageEngineConfig primaryStorage;
    private StorageEngineConfig replicaStorage;
    private List<StorageEngineConfig> secondaryStorages = new ArrayList<StorageEngineConfig>();
    private List<FieldInfo> fieldDefinitions;
    private Map<String, String> metadata = new HashMap<String, String>();

    public TableSchemaInfo() {
    }

    public TableSchemaInfo(String name, String type) {
        this.name = name;
        this.primaryStorage = new StorageEngineConfig(type);
    }

    @Deprecated
    public TableSchemaInfo(String name, Map<String, String> metadata) {
        this.name = name;
        this.metadata = metadata;
    }

    public TableSchemaInfo clone() {
        TableSchemaInfo c = new TableSchemaInfo();
        c.setName(this.name);
        c.setId(this.id);
        c.setPrimaryStorage(this.primaryStorage.clone());
        if (this.replicaStorage != null) {
            c.setReplicaStorage(this.replicaStorage.clone());
        }
        ArrayList<StorageEngineConfig> l = new ArrayList<StorageEngineConfig>();
        for (StorageEngineConfig s : this.secondaryStorages) {
            l.add(s.clone());
        }
        c.setSecondaryStorages(l);
        c.setFieldDefinitions(this.cloneFieldDefinitions(this.fieldDefinitions));
        if (this.metadata != null) {
            c.setMetadata(new HashMap<String, String>(this.metadata));
        }
        return c;
    }

    private List<FieldInfo> cloneFieldDefinitions(List<FieldInfo> l) {
        if (l == null) {
            return null;
        }
        ArrayList<FieldInfo> cloned = new ArrayList<FieldInfo>();
        for (FieldInfo d : l) {
            cloned.add(FieldInfo.parse(d.toString()));
        }
        return cloned;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public StorageEngineConfig getPrimaryStorage() {
        return this.primaryStorage;
    }

    public void setPrimaryStorage(StorageEngineConfig primaryStorage) {
        this.primaryStorage = primaryStorage;
    }

    public StorageEngineConfig getReplicaStorage() {
        return this.replicaStorage;
    }

    public void setReplicaStorage(StorageEngineConfig replicaStorage) {
        this.replicaStorage = replicaStorage;
    }

    public List<StorageEngineConfig> getSecondaryStorages() {
        return this.secondaryStorages;
    }

    public void setSecondaryStorages(List<StorageEngineConfig> secondaryStorages) {
        this.secondaryStorages = secondaryStorages;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public List<FieldInfo> getFieldDefinitions() {
        return this.fieldDefinitions;
    }

    public void setFieldDefinitions(List<FieldInfo> fieldDefinitions) {
        this.fieldDefinitions = fieldDefinitions;
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("table", this.name);
        m.put("id", this.id);
        m.put("type", this.primaryStorage.getType());
        m.put("base_path", this.primaryStorage.getBasePath());
        m.put("primary_configs", this.serialize(this.primaryStorage));
        m.put("replica_configs", this.serialize(this.replicaStorage));
        m.put("metadata", this.metadata);
        return m;
    }

    private Map<String, Object> serialize(StorageEngineConfig c) {
        if (c == null) {
            return null;
        }
        HashMap<String, Object> m = new HashMap<String, Object>();
        for (TableConfig t : c.getConfigs()) {
            if (t.getValues().size() <= 1) {
                m.put(t.getKey(), t.getValue());
                continue;
            }
            m.put(t.getKey(), t.getValues());
        }
        return m;
    }

    public String toString() {
        String replica = "";
        if (this.replicaStorage != null) {
            replica = ", replica={" + this.replicaStorage + "}";
        }
        String m = "";
        if (this.metadata != null && !this.metadata.isEmpty()) {
            m = ", metadata=" + this.metadata;
        }
        return "name=" + this.name + ", primary={" + this.primaryStorage + "}" + replica + m;
    }
}

