/*
 * Decompiled with CFR 0.152.
 */
package org.araqne.logdb.client;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class Message {
    private String guid;
    private Type type;
    private String session;
    private String requestId;
    private String source = "0";
    private String target = "0";
    private String method;
    private Map<String, Object> parameters = new HashMap<String, Object>();
    private String errorCode;
    private String errorMessage;

    public Message() {
        this.guid = UUID.randomUUID().toString();
        this.type = Type.Request;
        this.parameters = new HashMap<String, Object>();
    }

    public String getGuid() {
        return this.guid;
    }

    public void setGuid(String guid) {
        this.guid = guid;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public String getSession() {
        return this.session;
    }

    public void setSession(String session) {
        this.session = session;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
    }

    public Object get(String key) {
        return this.parameters.get(key);
    }

    public boolean containsKey(String key) {
        return this.parameters.containsKey(key);
    }

    public Long getLong(String key) {
        if (!this.parameters.containsKey(key)) {
            return null;
        }
        Object v = this.parameters.get(key);
        if (v == null) {
            return null;
        }
        if (v instanceof Integer) {
            return (long)((Integer)v);
        }
        return (Long)v;
    }

    public Integer getInt(String key) {
        if (!this.parameters.containsKey(key)) {
            return null;
        }
        return (Integer)this.parameters.get(key);
    }

    public String getString(String key) {
        if (!this.parameters.containsKey(key)) {
            return null;
        }
        return (String)this.parameters.get(key);
    }

    public Boolean getBoolean(String key) {
        if (!this.parameters.containsKey(key)) {
            return null;
        }
        return (Boolean)this.parameters.get(key);
    }

    public Date getDate(String key) {
        if (!this.parameters.containsKey(key)) {
            return null;
        }
        return (Date)this.parameters.get(key);
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public String toString() {
        return String.format("header [guid=%s, session=%d, source=%s, target=%s, method=%s, error=%s]", this.guid, this.session, this.source, this.target, this.method, this.errorMessage);
    }

    public static enum Type {
        None,
        Request,
        Response,
        Trap;

    }
}

