/*
 * Decompiled with CFR 0.152.
 */
package org.araqne.logdb.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.araqne.logdb.client.LogDbClient;
import org.araqne.logdb.client.LogQueryCommand;
import org.araqne.logdb.client.SubQuery;

public class LogQuery {
    private LogDbClient client;
    private int id;
    private String queryString;
    private String status;
    private long loadedCount;
    private boolean background;
    private int stamp;
    private Date startTime;
    private Date finishTime;
    private Integer errorCode;
    private String errorDetail;
    private Long elapsed;
    private List<LogQueryCommand> commands = new ArrayList<LogQueryCommand>();
    private CopyOnWriteArrayList<WaitingCondition> waitingConditions;
    private List<SubQuery> subQueries = new ArrayList<SubQuery>();

    public LogQuery(LogDbClient client, int id, String queryString) {
        this.client = client;
        this.id = id;
        this.queryString = queryString;
        this.status = "Stopped";
        this.loadedCount = 0L;
        this.waitingConditions = new CopyOnWriteArrayList();
    }

    public int getId() {
        return this.id;
    }

    public int getStamp() {
        return this.stamp;
    }

    public void setStamp(int stamp) {
        this.stamp = stamp;
    }

    public long getLoadedCount() {
        return this.loadedCount;
    }

    public String getStatus() {
        return this.getStatus(false);
    }

    public String getStatus(boolean refresh) {
        if (refresh) {
            try {
                if (this.client != null) {
                    this.client.getQuery(this.id);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntil(Long count) {
        WaitingCondition cond = new WaitingCondition(count);
        try {
            this.waitingConditions.add(cond);
            Object object = cond.signal;
            synchronized (object) {
                try {
                    while (!(this.status.equals("Ended") || this.status.equals("Cancelled") || count != null && this.loadedCount >= count)) {
                        cond.signal.wait(100L);
                    }
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
        }
        finally {
            this.waitingConditions.remove(cond);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCount(long count, long stamp) {
        if (stamp != 0L && (long)this.stamp >= stamp) {
            return;
        }
        this.loadedCount = count;
        for (WaitingCondition cond : this.waitingConditions) {
            if (cond.threshold == null || cond.threshold > this.loadedCount) continue;
            Object object = cond.signal;
            synchronized (object) {
                cond.signal.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateStatus(String status, long stamp) {
        if (stamp != 0L && (long)this.stamp >= stamp) {
            return;
        }
        this.status = status;
        if (status.equals("Ended") || status.equals("Cancelled")) {
            for (WaitingCondition cond : this.waitingConditions) {
                Object object = cond.signal;
                synchronized (object) {
                    cond.signal.notifyAll();
                }
            }
        }
    }

    public boolean isBackground() {
        return this.background;
    }

    public void setBackground(boolean background) {
        this.background = background;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getFinishTime() {
        return this.finishTime;
    }

    public void setFinishTime(Date finishTime) {
        this.finishTime = finishTime;
    }

    @Deprecated
    public Date getLastStarted() {
        return this.startTime;
    }

    @Deprecated
    public void setLastStarted(Date lastStarted) {
        this.startTime = lastStarted;
    }

    public Long getElapsed() {
        return this.elapsed;
    }

    public void setElapsed(Long elapsed) {
        this.elapsed = elapsed;
    }

    public List<LogQueryCommand> getCommands() {
        return this.commands;
    }

    public void setCommands(List<LogQueryCommand> commands) {
        this.commands = commands;
    }

    public List<SubQuery> getSubQueries() {
        return this.subQueries;
    }

    public void setSubQueries(List<SubQuery> subQueries) {
        this.subQueries = subQueries;
    }

    public Integer getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(Integer errorCode) {
        this.errorCode = errorCode;
    }

    public String getErrorDetail() {
        return this.errorDetail;
    }

    public void setErrorDetail(String errorDetail) {
        this.errorDetail = errorDetail;
    }

    public String toString() {
        return "id=" + this.id + ", query=" + this.queryString + ", status=" + this.status + ", loaded=" + this.loadedCount;
    }

    private class WaitingCondition {
        private Long threshold;
        private Object signal = new Object();

        public WaitingCondition(Long threshold) {
            this.threshold = threshold;
        }
    }
}

