/*
 * Decompiled with CFR 0.152.
 */
package org.araqne.api;

import java.net.URL;

public class PackageRepository {
    private String alias;
    private URL url;
    private boolean isAuthRequired;
    private String account;
    private String password;
    private String trustStoreAlias;
    private String keyStoreAlias;

    public static PackageRepository create(String alias, URL url) {
        PackageRepository r = new PackageRepository();
        r.alias = alias;
        r.url = url;
        return r;
    }

    public static PackageRepository createHttpAuth(String alias, URL url, String account, String password) {
        PackageRepository r = PackageRepository.create(alias, url);
        r.isAuthRequired = true;
        r.account = account;
        r.password = password;
        return r;
    }

    public static PackageRepository createHttps(String alias, URL url, String trustStoreAlias, String keyStoreAlias) {
        PackageRepository r = PackageRepository.create(alias, url);
        r.trustStoreAlias = trustStoreAlias;
        r.keyStoreAlias = keyStoreAlias;
        return r;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public URL getUrl() {
        return this.url;
    }

    public void setUrl(URL url) {
        this.url = url;
    }

    public boolean isAuthRequired() {
        return this.isAuthRequired;
    }

    public void setAuthRequired(boolean isAuthRequired) {
        this.isAuthRequired = isAuthRequired;
    }

    public String getAccount() {
        return this.account;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getTrustStoreAlias() {
        return this.trustStoreAlias;
    }

    public void setTrustStoreAlias(String trustStoreAlias) {
        this.trustStoreAlias = trustStoreAlias;
    }

    public String getKeyStoreAlias() {
        return this.keyStoreAlias;
    }

    public void setKeyStoreAlias(String keyStoreAlias) {
        this.keyStoreAlias = keyStoreAlias;
    }

    public boolean isHttps() {
        return this.url.getProtocol().equals("https");
    }

    public String toString() {
        if (this.isHttps()) {
            return String.format("{alias: %s, url: %s, truststore: %s, keystore: %s}", this.alias, this.url, this.trustStoreAlias, this.keyStoreAlias);
        }
        if (this.isAuthRequired) {
            return String.format("{alias: %s, url: %s, account: %s, password: %s}", this.alias, this.url, this.account, this.password);
        }
        return String.format("{alias: %s, url: %s}", this.alias, this.url);
    }

    public boolean isLocalFilesystem() {
        return this.url.getProtocol().equals("file");
    }
}

