/*
 * Decompiled with CFR 0.152.
 */
package org.araqne.api;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.araqne.api.BundleRequirement;
import org.araqne.api.MavenArtifact;
import org.araqne.api.Version;

public class PackageDescriptor {
    private String name;
    private Version version;
    private Date date;
    private String description;
    private List<BundleRequirement> bundles;
    private List<MavenArtifact> artifacts;
    private List<String> startBundleNames;

    public PackageDescriptor(String name, Version version, Date date) {
        this.name = name;
        this.version = version;
        this.date = date;
        this.bundles = new ArrayList<BundleRequirement>();
        this.artifacts = new ArrayList<MavenArtifact>();
        this.startBundleNames = new ArrayList<String>();
    }

    public PackageDescriptor(String name, Version version, Date date, String description) {
        this(name, version, date);
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public Version getVersion() {
        return this.version;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public String getDescription() {
        return this.description;
    }

    public List<BundleRequirement> getBundleRequirements() {
        return this.bundles;
    }

    public List<MavenArtifact> getMavenArtifacts() {
        return this.artifacts;
    }

    public List<String> getStartBundleNames() {
        return this.startBundleNames;
    }

    public String toString() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return String.format("{name: %s, version: %s, date: %s, bundle count: %d, artifact count: %d, start bundles: %d}", this.name, this.version, dateFormat.format(this.date), this.bundles.size(), this.artifacts.size(), this.startBundleNames.size());
    }
}

