/*
 * Decompiled with CFR 0.152.
 */
package org.araqne.api;

import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Environment {
    public static String expandSystemProperties(String path) {
        Matcher m = Pattern.compile("\\$\\{(?!\\$\\{)(.*?)\\}").matcher(path);
        while (m.find()) {
            String replacement = System.getProperty(m.group(1));
            if (replacement == null) continue;
            path = path.replace(m.group(), replacement);
        }
        return path;
    }

    public static void setAraqneSystemProperties(String araqneDir) {
        if (System.getProperty("araqne.dir") == null) {
            System.setProperty("araqne.dir", new File(araqneDir).getAbsolutePath());
        }
        String araqneDirProp = System.getProperty("araqne.dir");
        if (System.getProperty("araqne.data.dir") == null) {
            System.setProperty("araqne.data.dir", new File(araqneDirProp, "data").getAbsolutePath());
        }
        if (System.getProperty("araqne.log.dir") == null) {
            System.setProperty("araqne.log.dir", new File(araqneDirProp, "log").getAbsolutePath());
        }
        if (System.getProperty("araqne.cache.dir") == null) {
            System.setProperty("araqne.cache.dir", new File(araqneDirProp, "cache").getAbsolutePath());
        }
        if (System.getProperty("araqne.download.dir") == null) {
            System.setProperty("araqne.download.dir", new File(araqneDirProp, "download").getAbsolutePath());
        }
        if (System.getProperty("araqne.cert.dir") == null) {
            System.setProperty("araqne.cert.dir", new File(araqneDirProp, "cert").getAbsolutePath());
        }
        if (System.getProperty("araqne.home.dir") == null) {
            System.setProperty("araqne.home.dir", new File(araqneDirProp, "home").getAbsolutePath());
        }
        if (System.getProperty("araqne.plugin.dir") == null) {
            System.setProperty("araqne.plugin.dir", new File(araqneDirProp, "plugin").getAbsolutePath());
        }
        new File(System.getProperty("araqne.plugin.dir")).mkdirs();
    }
}

