/*
 * Decompiled with CFR 0.152.
 */
package org.araqne.ansicode;

import org.araqne.ansicode.AnsiEscapeCode;

public class SetColorCode
extends AnsiEscapeCode {
    private Color backColor;
    private Color foreColor;
    private boolean highIntensity;

    public SetColorCode(Color backgroundColor, Color foregroundColor) {
        this(backgroundColor, foregroundColor, false);
    }

    public SetColorCode(Color backgroundColor, Color foregroundColor, boolean highIntensity) {
        this.backColor = backgroundColor;
        this.foreColor = foregroundColor;
        this.highIntensity = highIntensity;
    }

    private int getColorCode(Color color) {
        switch (color) {
            case Black: {
                return 0;
            }
            case Red: {
                return 1;
            }
            case Green: {
                return 2;
            }
            case Yellow: {
                return 3;
            }
            case Blue: {
                return 4;
            }
            case Magenta: {
                return 5;
            }
            case Cyan: {
                return 6;
            }
            case White: {
                return 7;
            }
            case Reset: {
                return 9;
            }
        }
        throw new RuntimeException("Invalid color code. not reachable.");
    }

    private int getForeColor() {
        return 30 + this.getColorCode(this.foreColor);
    }

    private int getBackColor() {
        return 40 + this.getColorCode(this.backColor);
    }

    @Override
    public byte[] toByteArray() {
        String intensity = this.highIntensity ? "1" : "0";
        return this.wrapCSI(intensity + ";" + this.getForeColor() + ";" + this.getBackColor() + "m");
    }

    public static enum Color {
        Black,
        Red,
        Green,
        Yellow,
        Blue,
        Magenta,
        Cyan,
        White,
        Reset;


        public static Color parse(int code) {
            for (Color color : Color.values()) {
                if (color.ordinal() != code) continue;
                return color;
            }
            return null;
        }
    }
}

