/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.script;

import java.io.File;
import java.net.URL;
import org.sikuli.basics.FileManager;
import org.sikuli.script.RunTime;
import org.sikuli.util.JythonHelper;

public class SikulixForJython {
    private static SikulixForJython instance = null;
    private static final int lvl = 3;

    private SikulixForJython() {
    }

    public static SikulixForJython get() {
        if (null == instance) {
            instance = new SikulixForJython();
        }
        return instance;
    }

    static {
        JythonHelper helper = JythonHelper.get();
        helper.log(3, "SikulixForJython: init: starting", new Object[0]);
        RunTime runTime = RunTime.get();
        String sikuliStuff = "sikuli/Sikuli";
        File fSikuliStuff = helper.existsSysPathModule(sikuliStuff);
        String libSikuli = "/Lib/" + sikuliStuff + ".py";
        if (null == fSikuliStuff) {
            String fpSikuliStuff;
            URL uSikuliStuff = runTime.resourceLocation(libSikuli);
            if (uSikuliStuff == null) {
                runTime.dumpClassPath();
                helper.terminate(1, "no suitable sikulix...jar on classpath", new Object[0]);
            }
            if ("jar".equals(uSikuliStuff.getProtocol())) {
                fpSikuliStuff = uSikuliStuff.getPath().split("!")[0].substring(5);
                fpSikuliStuff = new File(FileManager.normalizeAbsolute(fpSikuliStuff, false), "Lib").getAbsolutePath();
            } else {
                fpSikuliStuff = new File(uSikuliStuff.getPath()).getAbsolutePath();
                fpSikuliStuff = new File(fpSikuliStuff.substring(0, fpSikuliStuff.length() - libSikuli.length()), "Lib").getAbsolutePath();
            }
            if (!helper.hasSysPath(fpSikuliStuff)) {
                helper.log(3, "sikuli/*.py not found on current Jython::sys.path", new Object[0]);
                helper.addSysPath(fpSikuliStuff);
                if (!helper.hasSysPath(fpSikuliStuff)) {
                    helper.terminate(1, "not possible to add to Jython::sys.path:\n%s", fpSikuliStuff);
                }
                helper.log(3, "added as Jython::sys.path[0]:\n%s", fpSikuliStuff);
            } else {
                helper.log(3, "sikuli/*.py is on Jython::sys.path at:\n%s", fpSikuliStuff);
            }
        }
        helper.addSitePackages();
        helper.log(3, "SikulixForJython: init: success", new Object[0]);
    }
}

