/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.script;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Scanner;
import javax.script.ScriptEngine;
import org.sikuli.basics.Debug;
import org.sikuli.script.ImagePath;
import org.sikuli.script.RunTime;
import org.sikuli.script.Runner;

public class RunServer {
    private static ServerSocket server = null;
    private static PrintWriter out = null;
    private static Scanner in = null;
    private static boolean isHandling = false;
    private static boolean shouldStop = false;
    private static int logLevel = 0;
    static File isRunning = null;
    static FileOutputStream isRunningFile = null;
    static ScriptEngine jsRunner = null;
    static File scriptFolder = null;
    static String scriptFolderNet = null;
    static File imageFolder = null;
    static String imageFolderNet = null;

    private static void log(int lvl, String message, Object ... args) {
        if (lvl < 0 || lvl >= logLevel) {
            System.out.println((lvl < 0 ? "[error] " : "[info] ") + String.format("RunServer: " + message, args));
        }
    }

    private static void log(String message, Object ... args) {
        RunServer.log(0, message, args);
    }

    private RunServer() {
    }

    public static boolean run(String[] args) {
        if (args == null) {
            args = new String[]{};
        }
        String userArgs = "";
        for (String userArg : RunTime.get().getArgs()) {
            userArgs = userArgs + userArg + " ";
        }
        if (!userArgs.isEmpty()) {
            userArgs = "\nWith User parameters: " + userArgs;
        }
        int port = RunServer.getPort(args.length > 0 ? args[0] : null);
        try {
            try {
                if (port > 0) {
                    RunServer.log(3, "Starting: trying port: %d %s", port, userArgs);
                    server = new ServerSocket(port);
                }
            }
            catch (Exception ex) {
                RunServer.log(-1, "Starting: " + ex.getMessage(), new Object[0]);
            }
            if (server == null) {
                RunServer.log(-1, "could not be started", new Object[0]);
                return false;
            }
            String theIP = InetAddress.getLocalHost().getHostAddress();
            String theServer = String.format("%s %d", theIP, port);
            isRunning = new File(RunTime.get().fSikulixStore, "RunServer.txt");
            try {
                isRunning.createNewFile();
                isRunningFile = new FileOutputStream(isRunning);
                if (null == isRunningFile.getChannel().tryLock()) {
                    RunServer.log(-1, "Terminating on FatalError: already running", new Object[0]);
                    return false;
                }
                isRunningFile.write(theServer.getBytes());
            }
            catch (Exception ex) {
                RunServer.log(-1, "Terminating on FatalError: cannot access to lock for/n" + isRunning, new Object[0]);
                return false;
            }
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    RunServer.log(3, "final cleanup", new Object[0]);
                    if (isRunning != null) {
                        try {
                            isRunningFile.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        isRunning.delete();
                    }
                }
            });
            do {
                RunServer.log("now waiting on port: %d at %s", port, theIP);
                Socket socket = server.accept();
                out = new PrintWriter(socket.getOutputStream());
                in = new Scanner(socket.getInputStream());
                HandleClient client = new HandleClient(socket);
                isHandling = true;
                while (true) {
                    if (socket.isClosed()) break;
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException ex) {}
                }
                shouldStop = client.getShouldStop();
            } while (!shouldStop);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!isHandling) {
            RunServer.log(-1, "start handling not possible: " + port, new Object[0]);
            return false;
        }
        RunServer.log("now stopped on port: " + port, new Object[0]);
        return true;
    }

    private static int getPort(String p) {
        int port;
        int pDefault = 50001;
        if (p != null) {
            try {
                port = Integer.parseInt(p);
            }
            catch (NumberFormatException ex) {
                RunServer.log(-1, "given port not useable: %s --- using default", p);
                return pDefault;
            }
        } else {
            return pDefault;
        }
        if (port < 1024) {
            port += pDefault;
        }
        return port;
    }

    private static class HandleClient
    implements Runnable {
        private volatile boolean keepRunning;
        private boolean shouldKeep = false;
        Thread thread;
        Socket socket;
        Boolean shouldStop = false;
        boolean isHTTP = false;
        String request;
        String rCommand;
        String rRessource;
        String rVersion = "HTTP/1.1";
        String rQuery;
        String[] rArgs;
        String rMessage = "";
        String rStatus;
        String rStatusOK = "200 OK";
        String rStatusBadRequest = "400 Bad Request";
        String rStatusNotFound = "404 Not Found";
        String rStatusServerError = "500 Internal Server Error";
        String rStatusServiceNotAvail = "503 Service Unavailable";
        Object evalReturnObject;
        String runTypeJS = "JavaScript";
        String runTypePY = "Python";
        String runTypeRB = "Ruby";
        String runType = this.runTypeJS;

        public HandleClient(Socket sock) {
            this.init(sock);
        }

        private void init(Socket sock) {
            this.socket = sock;
            if (in == null || out == null) {
                RunServer.log(-1, "communication not established", new Object[0]);
                System.exit(1);
            }
            this.thread = new Thread((Runnable)this, "HandleClient");
            this.keepRunning = true;
            this.thread.start();
        }

        public boolean getShouldStop() {
            return this.shouldStop;
        }

        @Override
        public void run() {
            Debug.on(3);
            RunServer.log("now handling client: " + this.socket, new Object[0]);
            while (this.keepRunning) {
                try {
                    String inLine = in.nextLine();
                    if (inLine == null) continue;
                    if (!this.isHTTP) {
                        RunServer.log("processing: <%s>", new Object[]{inLine});
                    }
                    boolean success = true;
                    if (inLine.startsWith("GET /") && inLine.contains("HTTP/")) {
                        this.isHTTP = true;
                        this.request = inLine;
                        continue;
                    }
                    if (this.isHTTP && !inLine.isEmpty()) continue;
                    if (!this.isHTTP) {
                        this.request = "GET /" + inLine + " HTTP/1.1";
                    }
                    if (success = this.checkRequest(this.request)) {
                        if (this.rCommand.contains("STOP")) {
                            this.rMessage = "stopping server";
                            this.shouldStop = true;
                            this.shouldKeep = false;
                        } else if (this.rCommand.contains("EXIT")) {
                            this.rMessage = "stopping client";
                            this.shouldKeep = false;
                        } else if (this.rCommand.startsWith("START")) {
                            this.runType = this.runTypeJS;
                            if (this.rCommand.length() > 5) {
                                if ("P".equals(this.rCommand.substring(5, 6))) {
                                    this.runType = this.runTypePY;
                                } else if ("R".equals(this.rCommand.substring(5, 6))) {
                                    this.runType = this.runTypeRB;
                                }
                            }
                            success = this.startRunner(this.runType, null, null);
                            this.rMessage = "startRunner for: " + this.runType;
                            if (!success) {
                                this.rMessage = "startRunner: not possible for: " + this.runType;
                                this.rStatus = this.rStatusServiceNotAvail;
                            }
                        } else if (this.rCommand.startsWith("SCRIPTS")) {
                            if (this.rRessource.isEmpty()) {
                                this.rMessage = "no scriptFolder given ";
                                this.rStatus = this.rStatusBadRequest;
                                success = false;
                            } else {
                                scriptFolder = this.getFolder(this.rRessource);
                                if (scriptFolder.getPath().startsWith("__NET/")) {
                                    scriptFolderNet = "http://" + scriptFolder.getPath().substring(6);
                                    this.rMessage = "scriptFolder now: " + scriptFolderNet;
                                } else {
                                    scriptFolderNet = null;
                                    this.rMessage = "scriptFolder now: " + scriptFolder.getAbsolutePath();
                                    if (!scriptFolder.exists()) {
                                        this.rMessage = "scriptFolder not found: " + scriptFolder.getAbsolutePath();
                                        this.rStatus = this.rStatusNotFound;
                                        success = false;
                                    }
                                }
                            }
                        } else if (this.rCommand.startsWith("IMAGES")) {
                            if (this.rRessource.isEmpty()) {
                                this.rMessage = "no imageFolder given ";
                                this.rStatus = this.rStatusBadRequest;
                                success = false;
                            } else {
                                String asImagePath;
                                imageFolder = this.getFolder(this.rRessource);
                                if (imageFolder.getPath().startsWith("__NET/")) {
                                    imageFolderNet = "http://" + imageFolder.getPath().substring(6);
                                    this.rMessage = "imageFolder now: " + imageFolderNet;
                                    asImagePath = imageFolderNet;
                                } else {
                                    String fpGiven = imageFolder.getAbsolutePath();
                                    if (!imageFolder.exists() && !(imageFolder = new File(imageFolder.getAbsolutePath() + ".sikuli")).exists()) {
                                        this.rMessage = "imageFolder not found: " + fpGiven;
                                        this.rStatus = this.rStatusNotFound;
                                        success = false;
                                    }
                                    asImagePath = imageFolder.getAbsolutePath();
                                }
                                this.rMessage = "imageFolder now: " + asImagePath;
                                ImagePath.add(asImagePath);
                            }
                        } else if (this.rCommand.startsWith("RUN")) {
                            String script = this.rRessource;
                            File fScript = null;
                            File fScriptScript = null;
                            if (scriptFolderNet != null) {
                                this.rMessage = "runScript from net not yet supported";
                                this.rStatus = this.rStatusServiceNotAvail;
                                success = false;
                            }
                            if (success) {
                                String scriptScript;
                                fScript = new File(scriptFolder, script);
                                if (!fScript.exists()) {
                                    script = script.endsWith(".sikuli") ? script.replace(".sikuli", "") : script + ".sikuli";
                                    fScript = new File(scriptFolder, script);
                                }
                                if (!(success = (fScriptScript = new File(fScript, (scriptScript = script.replace(".sikuli", "")) + ".js")).exists())) {
                                    fScriptScript = new File(fScript, scriptScript + ".py");
                                    boolean bl = success = fScript.exists() && fScriptScript.exists();
                                    if (!success) {
                                        this.rMessage = "runScript: script not found, not valid or not supported " + fScriptScript.toString();
                                    }
                                    this.runType = this.runTypePY;
                                }
                            }
                            if (success) {
                                ImagePath.setBundlePath(fScript.getAbsolutePath());
                                success = this.startRunner(this.runType, fScript, fScriptScript);
                            }
                        } else if (this.rCommand.startsWith("EVAL")) {
                            if (jsRunner != null) {
                                String line = this.rQuery;
                                try {
                                    this.evalReturnObject = jsRunner.eval(line);
                                    this.rMessage = "runStatement: returned: " + (this.evalReturnObject == null ? "null" : this.evalReturnObject.toString());
                                    success = true;
                                }
                                catch (Exception ex) {
                                    this.rMessage = "runStatement: raised exception on eval: " + ex.toString();
                                    success = false;
                                }
                            } else {
                                this.rMessage = "runStatement: not possible --- no runner";
                                this.rStatus = this.rStatusServiceNotAvail;
                                success = false;
                            }
                        }
                    }
                    String retVal = "";
                    if (this.isHTTP) {
                        retVal = "HTTP/1.1 " + this.rStatus;
                        String state = (success ? "PASS " : "FAIL ") + this.rStatus.substring(0, 3) + " ";
                        retVal = retVal + "\r\n\r\n" + state + this.rMessage + "\r";
                    } else {
                        retVal = (success ? "isok:\n" : "fail:\n") + this.rMessage + "\n###+++###";
                    }
                    try {
                        out.println(retVal);
                        out.flush();
                        RunServer.log("returned:\n" + retVal.replace("###+++###", ""), new Object[0]);
                    }
                    catch (Exception ex) {
                        RunServer.log(-1, "write response: Exception:\n" + ex.getMessage(), new Object[0]);
                    }
                    this.stopRunning();
                }
                catch (Exception ex) {
                    RunServer.log(-1, "while processing: Exception:\n" + ex.getMessage(), new Object[0]);
                    this.shouldKeep = false;
                    this.stopRunning();
                }
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ex) {
                this.shouldKeep = false;
                this.stopRunning();
            }
        }

        public void stopRunning() {
            if (!this.shouldKeep) {
                in.close();
                out.close();
                try {
                    this.socket.close();
                }
                catch (IOException ex) {
                    RunServer.log(-1, "fatal: socket not closeable", new Object[0]);
                    System.exit(1);
                }
                this.keepRunning = false;
            }
        }

        private File getFolder(String path) {
            File aFolder = new File(path);
            if (path.toLowerCase().startsWith("/home/")) {
                path = path.substring(6);
                aFolder = new File(RunTime.get().fUserDir, path);
            } else if (path.toLowerCase().startsWith("/net/")) {
                path = "__NET/" + path.substring(5);
                aFolder = new File(path);
            } else if (RunTime.get().runningWindows) {
                // empty if block
            }
            return aFolder;
        }

        private boolean checkRequest(String request) {
            this.shouldKeep = false;
            this.rCommand = "NOOP";
            this.rMessage = "invalid: " + request;
            this.rStatus = this.rStatusBadRequest;
            String[] parts = request.split("\\s");
            if (parts.length != 3 || !"GET".equals(parts[0]) || !parts[1].startsWith("/")) {
                return false;
            }
            if (!this.rVersion.equals(parts[2])) {
                return false;
            }
            String cmd = parts[1].substring(1);
            if (cmd.startsWith("X")) {
                cmd = cmd.substring(1);
                this.shouldKeep = true;
            }
            parts = cmd.split("\\?");
            cmd = parts[0];
            this.rQuery = "";
            if (parts.length > 1) {
                this.rQuery = parts[1];
            }
            if (!"START,STARTP,STOP,EXIT,SCRIPTS,IMAGES,RUN,EVAL,".contains(((parts = cmd.split("/"))[0] + ",").toUpperCase())) {
                this.rMessage = "invalid command: " + request;
                return false;
            }
            this.rCommand = parts[0].toUpperCase();
            this.rMessage = "";
            this.rStatus = this.rStatusOK;
            this.rRessource = "";
            if (parts.length > 1) {
                this.rRessource = cmd.substring(this.rCommand.length());
            }
            return true;
        }

        private boolean startRunner(String runType, File fScript, File fScriptScript) {
            if (this.runTypeJS.equals(runType)) {
                if (jsRunner == null) {
                    try {
                        jsRunner = Runner.initjs();
                        String prolog = "";
                        prolog = Runner.prologjs(prolog);
                        prolog = Runner.prologjs(prolog);
                        jsRunner.eval(prolog);
                    }
                    catch (Exception ex) {
                        this.rMessage = "startRunner JavaScript: not possible";
                        this.rStatus = this.rStatusServiceNotAvail;
                        return false;
                    }
                }
                if (fScript == null) {
                    return true;
                }
                if (jsRunner != null) {
                    try {
                        this.evalReturnObject = jsRunner.eval(new FileReader(fScriptScript));
                        this.rMessage = "runScript: returned: " + (this.evalReturnObject == null ? "null" : this.evalReturnObject.toString());
                        return this.evalReturnObject != null;
                    }
                    catch (Exception ex) {
                        this.rMessage = "runScript: script raised exception on run: " + ex.toString();
                        return false;
                    }
                }
                return false;
            }
            if (this.runTypePY.equals(runType)) {
                Integer retval = 0;
                if (!Runner.initpy()) {
                    retval = -1;
                }
                if (fScript != null && retval == 0) {
                    this.evalReturnObject = Runner.run(fScript.getAbsolutePath());
                    try {
                        retval = Integer.parseInt(this.evalReturnObject.toString());
                        if (retval == -999) {
                            retval = 0;
                        }
                    }
                    catch (Exception ex) {
                        retval = 0;
                    }
                }
                if (retval < 0) {
                    this.rMessage = "startRunner Python: not possible or crashed with exception";
                    this.rStatus = this.rStatusServiceNotAvail;
                    return false;
                }
                if (fScript != null) {
                    this.rMessage = "runScript: returned: " + retval.toString();
                }
            }
            return true;
        }
    }
}

